

; 8-Channel Learning Remote Control IR Receiver
; learns code from NEC, Sony, RC5 and RC6 IR encoding

	ERRORLEVEL -302
	ERRORLEVEL -306

	    list      p=16F1459        	; list directive to define processor
     #include <p16F1459.inc>        ; processor specific variable definitions


;Program Configuration Register 1
		__CONFIG    _CONFIG1, _FOSC_INTOSC & _WDTE_OFF & _PWRTE_ON & _MCLRE_ON & _CP_OFF & _BOREN_OFF & _CLKOUTEN_OFF &_IESO_OFF & _FCMEN_OFF

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _WRT_OFF & _CPUDIV_NOCLKDIV & _USBLSCLK_24MHz & _PLLMULT_4x & _PLLEN_DISABLED & _STVREN_ON & _BORV_HI & _LPBOR_OFF & _LVP_OFF 

; RAM starts at H'20'
TIMER_TEMP		equ	H'20'	; VR1 timer value for during learning mode
LED_DUTY		equ	H'21'	; Ack LED duty cycle drive counter
INT_FLG			equ	H'22'	; flag to indicate 50us interrupt
STORE1			equ	H'23'	; delay counter	
STORE2			equ	H'24'	; delay counter
SWITCH			equ	H'25'	; switch flag
TEMP			equ	H'26'	; temporary
AD_STORE		equ	H'27'	; A/D storage
SHOW			equ	H'28'	; show protocol (flash ACK.LED9)
T1_STO_H		equ	H'29'	; timer1 store ms byte
T1_STO_L		equ	H'2A'	; timer1 store ls byte	
TEMPM			equ	H'2B'	; temp ms byte
TEMPL			equ	H'2C'	; temp ls byte
TEMP2M			equ	H'2D'	; temp2 ms byte
TEMP2L			equ	H'2E'	; temp2 ls byte
INTCON_STORE	equ	H'2F'	; store intcon setting
TMR_1			equ	H'30'	; working timer for channel 1
TMR_2			equ	H'31'	; working timer for channel 2
TMR_3			equ	H'32'	; working timer for channel 2
TMR_4			equ	H'33'	; working timer for channel 4
TMR_5			equ	H'34'	; working timer for channel 5
TMR_6			equ	H'35'	; working timer for channel 6
TMR_7			equ	H'36'	; working timer for channel 7
TMR_8			equ	H'37'	; working timer for channel 8
SW_VAL			equ	H'38'	; programming/ switch or channel value
PROTOCOL		equ	H'39'	; protocol of IR reading
ACK_FLASH		equ	H'3A'	; flag for whether ACK. LED flashes on receipt of IR signal
MOM_TOG			equ	H'3B'	; momentary / toggle flag for LED
FLASH_T			equ	H'3C'	; flashing timer for momentary indication when program/learn mode
TIMEOUT			equ	H'3D'	; timeout in program/learning mode
PORTA_STO		equ	H'3E'	; porta store
PORTB_STO		equ	H'3F'	; portb store
PORTC_STO		equ	H'40'	; portc store	
MODE			equ	H'41'	; learn or receive mode
NEC_X			equ	H'42'	; NEC repeat flags bits 0-7 correspond to Channel 1-8 for NEC code repeats
TEMPS			equ	H'43'	; temporary store of timer value
FLASH_ACK		equ	H'44'	; flash ACK LED flag when waiting for IR signal during learning
DLY_XTN			equ	H'45'	; delay extension

; DATA ( 4 blocks for writing/reading) data in the ls bytes only. 
; OUT 1
PROTOCOL1		equ	H'48'	; Protocol is least significant 4-bits 0 = NEC, 1 = Sony;  2 = RC5; 3 = RC6. Plus for Sony, the address length is in ms 4-bits 0= 5-bits, 1 = 8 bits, 2 = 13bits
ADDRESS1ms		equ	H'49'	; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
ADDRESS1ls		equ	H'4A'	; IR code address ls byte
COMMAND1		equ	H'4B'	; IR code command
TIMER1			equ	H'4C'	; output timer (if zero, then toggle operation, otherwise momentary with timer)

; OUT 2
PROTOCOL2		equ	H'4D'	; Protocol is least significant 4-bits 0 = NEC, 1 = Sony;  2 = RC5; 3 = RC6. Plus for Sony, the address length is in ms 4-bits 0= 5-bits, 1 = 8 bits, 2 = 13bits
ADDRESS2ms		equ	H'4E'	; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
ADDRESS2ls		equ	H'4F'	; IR code address ls byte
COMMAND2		equ	H'50'	; IR code command
TIMER2			equ	H'51'	; output timer (if zero, then toggle operation, otherwise momentary with timer)

; OUT 3
PROTOCOL3		equ	H'52'	; Protocol is least significant 4-bits 0 = NEC, 1 = Sony;  2 = RC5; 3 = RC6. Plus for Sony, the address length is in ms 4-bits 0= 5-bits, 1 = 8 bits, 2 = 13bits
ADDRESS3ms		equ	H'53'	; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
ADDRESS3ls		equ	H'54'	; IR code address ls byte
COMMAND3		equ	H'55'	; IR code command
TIMER3			equ	H'56'	; output timer (if zero, then toggle operation, otherwise momentary with timer)

; OUT 4
PROTOCOL4		equ	H'57'	; Protocol is least significant 4-bits 0 = NEC, 1 = Sony;  2 = RC5; 3 = RC6. Plus for Sony, the address length is in ms 4-bits 0= 5-bits, 1 = 8 bits, 2 = 13bits
ADDRESS4ms		equ	H'58'	; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
ADDRESS4ls		equ	H'59'	; IR code address ls byte
COMMAND4		equ	H'5A'	; IR code command
TIMER4			equ	H'5B'	; output timer (if zero, then toggle operation, otherwise momentary with timer)

; OUT 5
PROTOCOL5		equ	H'5C'	; Protocol is least significant 4-bits 0 = NEC, 1 = Sony;  2 = RC5; 3 = RC6. Plus for Sony, the address length is in ms 4-bits 0= 5-bits, 1 = 8 bits, 2 = 13bits
ADDRESS5ms		equ	H'5D'	; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
ADDRESS5ls		equ	H'5E'	; IR code address ls byte
COMMAND5		equ	H'5F'	; IR code command
TIMER5			equ	H'60'	; output timer (if zero, then toggle operation, otherwise momentary with timer)

; OUT 6
PROTOCOL6		equ	H'61'	; Protocol is least significant 4-bits 0 = NEC, 1 = Sony;  2 = RC5; 3 = RC6. Plus for Sony, the address length is in ms 4-bits 0= 5-bits, 1 = 8 bits, 2 = 13bits
ADDRESS6ms		equ	H'62'	; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
ADDRESS6ls		equ	H'63'	; IR code address ls byte
COMMAND6		equ	H'64'	; IR code command
TIMER6			equ	H'65'	; output timer (if zero, then toggle operation, otherwise momentary with timer)

; OUT 7
PROTOCOL7		equ	H'66'	; Protocol is least significant 4-bits 0 = NEC, 1 = Sony;  2 = RC5; 3 = RC6. Plus for Sony, the address length is in ms 4-bits 0= 5-bits, 1 = 8 bits, 2 = 13bits
ADDRESS7ms		equ	H'67'	; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
ADDRESS7ls		equ	H'68'	; IR code address ls byte
COMMAND7		equ	H'69'	; IR code command
TIMER7			equ	H'6A'	; output timer (if zero, then toggle operation, otherwise momentary with timer)

; OUT 8
PROTOCOL8		equ	H'6B'	; Protocol is least significant 4-bits 0 = NEC, 1 = Sony;  2 = RC5; 3 = RC6. Plus for Sony, the address length is in ms 4-bits 0= 5-bits, 1 = 8 bits, 2 = 13bits
ADDRESS8ms		equ	H'6C'	; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
ADDRESS8ls		equ	H'6D'	; IR code address ls byte
COMMAND8		equ	H'6E'	; IR code command
TIMER8			equ	H'6F'	; output timer (if zero, then toggle operation, otherwise momentary with timer)

; All banks RAM

; IR remote control decoding
TEMP_VAL		equ	H'70'	; PGMDATA store
LOOPS			equ	H'71'	; counter during flash writes
REMOTE_A		equ	H'72'	; remote control Address byte
REM_A_BAR	 	equ	H'73'	; complementary value of address (NEC) or address extension
REM_A_MS		equ	H'74'	; ms byte of address (Sony) if 20bit format (13bit address)
REMOTE_C		equ	H'75'	; remote control Command byte
REM_C_BAR		equ	H'76'	; complementary value of command (NEC)
BIT_COUNT		equ	H'77'	; bit counter
SONY_ADD_L		equ	H'78'	; sony address length 5, 8 and 13 bits (for 12, 15 and 20 bits total when including command bits (7))
COUNTER			equ	H'79'	; counter for period
READADDMS		equ	H'7A'	; flash memory read address ms byte making up a 14 bit byte (ms byte has 6 bits)
READADDLS		equ	H'7B'  	; flash memory read address ls byte (ls byte has 8 bits)
RCV_ACK			equ	H'7C'	; flag to set Ack LED during IR reception

; ___________________________________________________________

; initial values
; located at high endurance flash (ls 8-bits only)
	 org	H'1F80'		; start address of where data memory for channel 1-8 is stored 

; initial values are changed upon programming during learning codes for each channel 
;               Protocol, Address (ms) Address (ls), Command, Timer
	
				DE	H'1A', H'1B', H'1C', H'1D', H'1E'	; channel 1, initial test values for channel 1 
				DE	H'2A', H'2B', H'2C', H'2D', H'2E' 	; channel 2
				DE	H'3A', H'3B', H'3C', H'3D', H'3E' 	; channel 3
				DE	H'4A', H'4B', H'4C', H'4D', H'4E' 	; channel 4
				DE	H'5A', H'5B', H'5C', H'5D', H'5E' 	; channel 5
				DE	H'6A', H'6B', H'6C', H'6D', H'6E' 	; channel 6
				DE	H'7A', H'7B', H'7C', H'7D', H'7E' 	; channel 7
				DE	H'8A', H'8B', H'8C', H'8D', H'8E' 	; channel 8, initial test values for channel 8
			 
; ******************************************************************

; start at memory 0

	org		0				; reset vector
	goto	MAIN

; interrupt vector
	org		4
INTERRUPT
	movlb	D'0'			; bank 0

; interrupt source
	btfsc	INTCON,TMR0IF	; timer 0 flag
	goto	FOR_TIMER1_OVR
	btfss	PIR1,TMR2IF
	retfie
	bcf		PIR1,TMR2IF

; timeout
	movf	TIMEOUT,w
	btfss	STATUS,Z
	decf	TIMEOUT,f

; channel timers 125ms per value
NXT_CH1
	movf	TMR_1,w			; working timer_1 for channel 1
	btfsc	STATUS,Z		; if already zero bypass
	goto	NXT_CH2
	decfsz	TMR_1,f			; channel 1 timer
	goto	NXT_CH2			; next timer
	bcf		PORTC,6			; when goes to zero, switch off channel 1

NXT_CH2
	movf	TMR_2,w			; working timer_x for channel x
	btfsc	STATUS,Z		; if already zero bypass
	goto	NXT_CH3
	decfsz	TMR_2,f			; channel x timer
	goto	NXT_CH3			; next timer
	bcf		PORTC,7			; when goes to zero, switch off channel x

NXT_CH3
	movf	TMR_3,w			; working timer_x for channel x
	btfsc	STATUS,Z		; if already zero bypass
	goto	NXT_CH4
	decfsz	TMR_3,f			; channel x timer
	goto	NXT_CH4			; next timer
	bcf		PORTB,7			; when goes to zero, switch off channel x

NXT_CH4
	movf	TMR_4,w			; working timer_x for channel x
	btfsc	STATUS,Z		; if already zero bypass
	goto	NXT_CH5
	decfsz	TMR_4,f			; channel x timer
	goto	NXT_CH5			; next timer
	bcf		PORTC,3			; when goes to zero, switch off channel x

NXT_CH5
	movf	TMR_5,w			; working timer_x for channel x
	btfsc	STATUS,Z		; if already zero bypass
	goto	NXT_CH6
	decfsz	TMR_5,f			; channel x timer
	goto	NXT_CH6			; next timer
	bcf		PORTC,4			; when goes to zero, switch off channel x

NXT_CH6
	movf	TMR_6,w			; working timer_x for channel x
	btfsc	STATUS,Z		; if already zero bypass
	goto	NXT_CH7
	decfsz	TMR_6,f			; channel x timer
	goto	NXT_CH7			; next timer
	bcf		PORTC,5			; when goes to zero, switch off channel x

NXT_CH7
	movf	TMR_7,w			; working timer_x for channel x
	btfsc	STATUS,Z		; if already zero bypass
	goto	NXT_CH8
	decfsz	TMR_7,f			; channel x timer
	goto	NXT_CH8			; next timer
	bcf		PORTA,4			; when goes to zero, switch off channel x

NXT_CH8
	movf	TMR_8,w			; working timer_x for channel x
	btfsc	STATUS,Z		; if already zero bypass
	goto	MTLF			; end
	decfsz	TMR_8,f			; channel x timer
	goto	MTLF			; end
	bcf		PORTA,5			; when goes to zero, switch off channel x
;......................................................................

MTLF
MOM_TOGGL_LED_FLASH; flash once (125ms) every second
; momentary / toggle LED flash
	incf	FLASH_T,f
	btfss	MOM_TOG,0		; if set then flash MOM/TOGGLE LED
	goto	ACK_WAIT_FLASH
	btfss	PORTB,4
	goto	TST2
	bcf		PORTB,4
	goto	T_ZERO	
TST2
; light only if bit 3 set 
	btfss	FLASH_T,3
	goto	T_ZERO
	bsf		PORTB,4
	clrf	FLASH_T
	goto	T_ZERO

ACK_WAIT_FLASH ; flash ACK LED while waiting for IR code during learning

; Ack. LED flash. Flash once (125ms) every 2 seconds
	incf	FLASH_T,f
	btfss	FLASH_ACK,0		; if set then flash ACK LED
	goto	T_ZERO
	bcf		PORTC,2
; light only if bit set
	btfss	FLASH_T,5
	goto	T_ZERO
	bsf		PORTC,2
	clrf	FLASH_T

T_ZERO
	btfss	INTCON,TMR0IF	; timer 0 flag
	retfie		
;...................................................................
; timer 	
FOR_TIMER1_OVR
; reload for 50us
	movlw	H'D0'			; 255-50 (2-cycle period taken to load timer 0 added)
	addwf	TMR0,f
	bsf		INT_FLG,0		; set flag to indicate a 50us period interrupt
; clear timer0 flag 
	bcf		INTCON,TMR0IF

; power on simulator LED
	btfsc	RCV_ACK,0		; flag to set Ack LED during IR reception
	retfie
	movf	MODE,w			; if zero(read mode) then light at low duty
	btfss	STATUS,Z
	retfie
	btfsc	FLASH_ACK,0		; if not to flash, then light with low duty
	retfie
LIGHT_LO
	btfss	PORTC,2
	goto	LT_LO
	bcf		PORTC,2
	clrf	LED_DUTY
	retfie
LT_LO
	incf	LED_DUTY,f
	btfsc	LED_DUTY,4		; sets duty cycle, bit 4 is 1/17 or 5.9%, if bit 3 then 1/9 or 11%
	bsf		PORTC,2
	retfie

; ***********************************************************
		
MAIN
	movlb	D'0'
	clrf	MOM_TOG			; momentary/ toggle LED off
;  set oscillator calibration
	movlb	D'1'			; bank 1
    movlw   D'0'     		; set oscillator to factory calibrated frequency 
    movwf   OSCTUNE
; set outputs low
	movlb	D'2'			; latch, bank 2
	movlw	B'00000000'	; 
	movwf	LATA
	movlw	B'00000000'	; 
	movwf	LATB
	movlw	B'00000000'	; 
	movwf	LATC
;USB
	movlb	D'29'
	bcf		UCON,3		; USB off
	bcf		UCON,1
; weak pullups off/on
	movlb	D'4'		; bank4	WPUA/B
	clrf	WPUA
	movlw	B'01100000' ; RB5,RB6 to S2,S1
	movwf	WPUB
; set I/O
	movlb	D'1'		; bank1	TRISA/B/C
	movlw   B'00001011'	; I/O 
	movwf   TRISA		; port A data direction register
	movlw	B'01100000'	; I/O 
	movwf	TRISB		; port B data direction register
	movlw	B'00000011'
	movwf	TRISC		; port C data direction 
; options
	movlw	B'00000000'	; weak pullups set via WPUA/B TMR0/2
	movwf	OPTION_REG	; 
; analog inputs
	movlb	D'3'		; bank3	ANSELA/B/C  AN4, AN5
	movlw	B'00000000'	; 
	movwf	ANSELA
	movlw	B'00000000' ; 
	movwf	ANSELB
	movlw	B'00000011'	; AN5,AN4  VR1,VR2
	movwf	ANSELC
; A/D select
	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00010000'	; AN4 start 
; 00010000 	; AN4	; VR2 Internal oscillator calibrate
; 00010100	; AN5	; VR1 Timer for momentary on period
	movwf	ADCON0
	movlw	B'00010000'	; left justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on
; oscillator	
	movlw	B'00111000'	; for 8MHz;
	movwf	OSCCON		; osc
; Timer1 
	movlb	D'0'		; bank 0	
	movlw 	B'00010001'	; divide by 2 for 1us per count
	movwf	T1CON
; timer2 set
	movlw	B'01111111'	; divide 16 by post scaler and 64 prescaler
	movwf	T2CON
	movlw	D'244'		; 125ms using D244. If FF then 131ms
	movwf	PR2			; 

; start up delay
	call	DELAY100	; 100ms

; initial values
	clrf	SW_VAL		; value of channel to select channels 1-8
	clrf	NEC_X		; NEC repeat flags
	clrf	FLASH_ACK	; flash ACK LED flag
	clrf	MOM_TOG		; flash momentary/toggle LED flag
	clrf	RCV_ACK		; allows Ack during IR reception and then low duty drive otherwise

; Start by a read of stored data
; retrieve IR Protocol and address plus command codes for 8-channels

; initial RAM location (H2028)
	movlw	H'20'
	movwf	FSR0H			; ms byte
	movlw	H'28'	
	movwf	FSR0L

	movlw	H'1F'			; ms address byte (H0700 start)
	movwf	READADDMS 
	movlw	H'80'
	movwf	READADDLS		; ls address byte
LOOP_RDA
	call	READ			; ms byte in TEMP_VAL
	movwf	TEMP			; ls byte
	movwi	FSR0++			; ls byte to RAM
; only using ls byte of flash so next two lines not used
;	movf	TEMP_VAL,w		; ms byte
;	movwi	FSR0++			; ms byte to RAM

; next flash memory read
	incf	READADDLS,f
	movf	READADDLS,w
	xorlw	H'28'			; stop at 28 (4F in RAM)	
	btfss	STATUS,Z
	goto	LOOP_RDA

; enable interrupts
	movlb	D'1'			; bank 1
	bsf		PIE1,TMR2IE		; timer 2 enable
	movlb	D'0'			; bank 0
	bcf		PIR1,TMR2IF		; timer 2 interrupt flag	
	bsf		INTCON,T0IE		; timer 0 interrupt
	bcf		INTCON,T0IF
	bsf		INTCON,PEIE
	bsf 	INTCON,GIE		; set global interrupt enable 

; Read calibration VR2 and set oscillator
	call	CALX	
	goto	CHECK_S1
CALX
	movlb	D'1'			; bank1	ADCON0/1/2
	movlw	B'00010000'		; channel 4 start 
; 00010000 	; AN4			; VR2 Internal oscillator calibrate
	movwf	ADCON0
	movlw	B'00010000'		; left justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON		; A/D on
	call	ACQUIRE_AD
	movwf	TEMPS			; ADRESH has 8-bit a/d value
; prepare value for osctune 
	lsrf	TEMPS,f	; shift right with a 0 at bit 7
; check bit 6 is set (determines upper or lower a/d value from H7F,H80)
	btfsc	TEMPS,6
	goto	SET6
; otherwise set bit 6
	bsf		TEMPS,6
	goto	OSC_CAL
SET6; clear bit 6
	bcf		TEMPS,6	
	movf	TEMPS,w			; get value
; set oscillator calibration
OSC_CAL
	movlb	D'1'			; bank 1
	movwf   OSCTUNE			; +/- 6% frequency adjustment in +/- 64 steps, from osctune value at 0 setting
	movlb	D'0'			; bank 0
	return

CHECK_S1

; check if S1 closed or open
	btfss	PORTB,5			; if high run normal mode 
	goto	PGLM			; program learning mode

;...................................................
; read IR codes
	clrf	MODE			; read mode
	clrf	ACK_FLASH		; ACK. LED flash flag
	call	START
	clrf	RCV_ACK			; 
	bcf		PORTC,2			; ACK LED off
; monitor/compare codes and respond
; if w returns with H'0F', then S1 was pressed

	movwf	TEMPS			; store 'w'
	xorlw	H'0F'			; S1 pressed
	btfsc	STATUS,Z
	goto	CHECK_S1 
	
;  compare 'w' against H'A0'
	movf	TEMPS,w
	xorlw	H'A0'			; valid code received
	btfsc	STATUS,Z
	goto	CHNL1
	movf	TEMPS,w
	xorlw	H'88'			; repeat code for NEC
	btfss	STATUS,Z
	goto	CHECK_S1		; code does not match NEC, Sony or RC5/6 preamble encoding or NEC repeat

; MATCHING preamble so check each channel

; compare received with stored code for channels 1-8
CHNL1
; Channel 1
	movf	PROTOCOL,w
	btfss	STATUS,Z		; if NEC check repeat flag
	goto	NO_NEC1
	btfss	NEC_X,0			; if set then intitial code was for NEC CH1
	goto	NO_NEC1_R		; no repeat signal flag
	movf	TEMPS,w
	xorlw   H'88'			; if H88, a repeat signal
	btfsc	STATUS,Z
	goto	EQU_1			; repeat momentary for channel 1, no extra checks required
NO_NEC1						; not NEC
NO_NEC1_R					; not NEC repeat signal
	clrf	NEC_X			; repeats off
	movf	PROTOCOL,w		; received protocol
	xorwf	PROTOCOL1,w		; stored protocol
	btfss	STATUS,Z		; check if the same
	goto	CHNL2			; check channel 2
	movf	REMOTE_A,w		; received remote address ls byte
	xorwf	ADDRESS1ls,w	; compare with stored
	btfss	STATUS,Z
	goto	CHNL2			; check channel 2

	movf	REMOTE_C,w		; received remote command
	xorwf	COMMAND1,w		; compare with stored
	btfss	STATUS,Z
	goto	CHNL2			; check channel 2

; bypass if Philips RC5
	movf	PROTOCOL,w
	xorlw	D'02'
	btfsc	STATUS,Z
	goto	EQU_1

; bypass if Philips RC6
	movf	PROTOCOL,w
	xorlw	D'03'
	btfsc	STATUS,Z
	goto	EQU_1

; REM_A_BAR for NEC and REM_A_MS for Sony. Test if one of these matches ADDRESS1ms
	movf	PROTOCOL,w		; if NEC, then
	btfss	STATUS,Z
	goto	SONY1
	movf	REM_A_BAR,w		; received remote address ms byte or complementary version of ls
	xorwf	ADDRESS1ms,w	; compare with stored
	btfsc	STATUS,Z
	goto	EQU_1			; correct 
	goto	CHNL2
SONY1
	movf	PROTOCOL,w		; if SONY 13 bit the requires comparison, if not 13 bit the values are 0
	xorlw	D'01'
	btfss	STATUS,Z
	goto	CHNL2
	movf	REM_A_MS,w		; received remote address ms byte or complementary version of ls
	xorwf	ADDRESS1ms,w	; compare with stored
	btfsc	STATUS,Z
	goto	EQU_1

CHNL2
; Channel 2
	movf	PROTOCOL,w
	btfss	STATUS,Z		; if NEC check repeat flag
	goto	NO_NEC2
	btfss	NEC_X,1			; if set then intitial code was for NEC_X,x (x=0 for Channel 1, 1 for Channel 2...)
	goto	NO_NEC2_R		; no repeat signal flag
	movf	TEMPS,w
	xorlw   H'88'			; if H88, a repeat signal
	btfsc	STATUS,Z
	goto	EQU_2			; repeat momentary for channel x, no extra checks required
NO_NEC2						; not NEC
NO_NEC2_R					; not NEC repeat signal
	clrf	NEC_X			; repeats off
	movf	PROTOCOL,w		; received protocol
	xorwf	PROTOCOL2,w		; stored protocol
	btfss	STATUS,Z		; check if the same
	goto	CHNL3			; check channel x+1
	movf	REMOTE_A,w		; received remote address ls byte
	xorwf	ADDRESS2ls,w	; compare with stored
	btfss	STATUS,Z
	goto	CHNL3			; check channel x+1

	movf	REMOTE_C,w		; received remote command
	xorwf	COMMAND2,w		; compare with stored
	btfss	STATUS,Z
	goto	CHNL3			; check channel x+1

; bypass if RC5
	movf	PROTOCOL,w
	xorlw	D'02'
	btfsc	STATUS,Z
	goto	EQU_2

; bypass if RC6
	movf	PROTOCOL,w
	xorlw	D'03'
	btfsc	STATUS,Z
	goto	EQU_2

; REM_A_BAR for NEC and REM_A_MS for Sony. Test if one of these matches ADDRESS1ms
	movf	PROTOCOL,w		; if NEC, then
	btfss	STATUS,Z
	goto	SONY2
	movf	REM_A_BAR,w		; received remote address ms byte or complementary version of ls
	xorwf	ADDRESS2ms,w	; compare with stored
	btfsc	STATUS,Z
	goto	EQU_2			; correct 
	goto	CHNL3
SONY2
	movf	PROTOCOL,w		; if SONY 13 bit the requires comparison, if not 13 bit the values are 0
	xorlw	D'01'
	btfss	STATUS,Z
	goto	CHNL3
	movf	REM_A_MS,w		; received remote address ms byte or complementary version of ls
	xorwf	ADDRESS2ms,w	; compare with stored
	btfsc	STATUS,Z
	goto	EQU_2

CHNL3
; Channel 3
	movf	PROTOCOL,w
	btfss	STATUS,Z		; if NEC check repeat flag
	goto	NO_NEC3
	btfss	NEC_X,2			; if set then intitial code was for NEC_X,x (x=0 for Channel 1, 1 for Channel 2...)
	goto	NO_NEC3_R		; no repeat signal flag
	movf	TEMPS,w
	xorlw   H'88'			; if H88, a repeat signal
	btfsc	STATUS,Z
	goto	EQU_3			; repeat momentary for channel x, no extra checks required
NO_NEC3						; not NEC
NO_NEC3_R					; not NEC repeat signal
	clrf	NEC_X			; repeats off
	movf	PROTOCOL,w		; received protocol
	xorwf	PROTOCOL3,w		; stored protocol
	btfss	STATUS,Z		; check if the same
	goto	CHNL4			; check channel x+1
	movf	REMOTE_A,w		; received remote address ls byte
	xorwf	ADDRESS3ls,w	; compare with stored
	btfss	STATUS,Z
	goto	CHNL4			; check channel x+1

	movf	REMOTE_C,w		; received remote command
	xorwf	COMMAND3,w		; compare with stored
	btfss	STATUS,Z
	goto	CHNL4			; check channel x+1

; bypass if RC5
	movf	PROTOCOL,w
	xorlw	D'02'
	btfsc	STATUS,Z
	goto	EQU_3

; bypass if RC6
	movf	PROTOCOL,w
	xorlw	D'03'
	btfsc	STATUS,Z
	goto	EQU_3

; REM_A_BAR for NEC and REM_A_MS for Sony. Test if one of these matches ADDRESS1ms
	movf	PROTOCOL,w		; if NEC, then
	btfss	STATUS,Z
	goto	SONY3
	movf	REM_A_BAR,w		; received remote address ms byte or complementary version of ls
	xorwf	ADDRESS3ms,w	; compare with stored
	btfsc	STATUS,Z
	goto	EQU_3			; correct 
	goto	CHNL4
SONY3
	movf	PROTOCOL,w		; if SONY 13 bit the requires comparison, if not 13 bit the values are 0
	xorlw	D'01'
	btfss	STATUS,Z
	goto	CHNL4
	movf	REM_A_MS,w		; received remote address ms byte or complementary version of ls
	xorwf	ADDRESS3ms,w	; compare with stored
	btfsc	STATUS,Z
	goto	EQU_3

CHNL4
; Channel 4
	movf	PROTOCOL,w
	btfss	STATUS,Z		; if NEC check repeat flag
	goto	NO_NEC4
	btfss	NEC_X,3			; if set then intitial code was for NEC_X,x (x=0 for Channel 1, 1 for Channel 2...)
	goto	NO_NEC4_R		; no repeat signal flag
	movf	TEMPS,w
	xorlw   H'88'			; if H88, a repeat signal
	btfsc	STATUS,Z
	goto	EQU_4			; repeat momentary for channel x, no extra checks required
NO_NEC4						; not NEC
NO_NEC4_R					; not NEC repeat signal
	clrf	NEC_X			; repeats off
	movf	PROTOCOL,w		; received protocol
	xorwf	PROTOCOL4,w		; stored protocol
	btfss	STATUS,Z		; check if the same
	goto	CHNL5			; check channel x+1
	movf	REMOTE_A,w		; received remote address ls byte
	xorwf	ADDRESS4ls,w	; compare with stored
	btfss	STATUS,Z
	goto	CHNL5			; check channel x+1

	movf	REMOTE_C,w		; received remote command
	xorwf	COMMAND4,w		; compare with stored
	btfss	STATUS,Z
	goto	CHNL5			; check channel x+1

; bypass if RC5
	movf	PROTOCOL,w
	xorlw	D'02'
	btfsc	STATUS,Z
	goto	EQU_4

; bypass if RC6
	movf	PROTOCOL,w
	xorlw	D'03'
	btfsc	STATUS,Z
	goto	EQU_4

; REM_A_BAR for NEC and REM_A_MS for Sony. Test if one of these matches ADDRESS1ms
	movf	PROTOCOL,w		; if NEC, then
	btfss	STATUS,Z
	goto	SONY4
	movf	REM_A_BAR,w		; received remote address ms byte or complementary version of ls
	xorwf	ADDRESS4ms,w	; compare with stored
	btfsc	STATUS,Z
	goto	EQU_4			; correct 
	goto	CHNL5
SONY4
	movf	PROTOCOL,w		; if SONY 13 bit the requires comparison, if not 13 bit the values are 0
	xorlw	D'01'
	btfss	STATUS,Z
	goto	CHNL5
	movf	REM_A_MS,w		; received remote address ms byte or complementary version of ls
	xorwf	ADDRESS4ms,w	; compare with stored
	btfsc	STATUS,Z
	goto	EQU_4

CHNL5
; Channel 5
	movf	PROTOCOL,w
	btfss	STATUS,Z		; if NEC check repeat flag
	goto	NO_NEC5
	btfss	NEC_X,4			; if set then intitial code was for NEC_X,x (x=0 for Channel 1, 1 for Channel 2...)
	goto	NO_NEC5_R		; no repeat signal flag
	movf	TEMPS,w
	xorlw   H'88'			; if H88, a repeat signal
	btfsc	STATUS,Z
	goto	EQU_5			; repeat momentary for channel x, no extra checks required
NO_NEC5						; not NEC
NO_NEC5_R					; not NEC repeat signal
	clrf	NEC_X			; repeats off
	movf	PROTOCOL,w		; received protocol
	xorwf	PROTOCOL5,w		; stored protocol
	btfss	STATUS,Z		; check if the same
	goto	CHNL6			; check channel x+1
	movf	REMOTE_A,w		; received remote address ls byte
	xorwf	ADDRESS5ls,w	; compare with stored
	btfss	STATUS,Z
	goto	CHNL6			; check channel x+1

	movf	REMOTE_C,w		; received remote command
	xorwf	COMMAND5,w		; compare with stored
	btfss	STATUS,Z
	goto	CHNL6			; check channel x+1

; bypass if RC5
	movf	PROTOCOL,w
	xorlw	D'02'
	btfsc	STATUS,Z
	goto	EQU_5

; bypass if RC6
	movf	PROTOCOL,w
	xorlw	D'03'
	btfsc	STATUS,Z
	goto	EQU_5

; REM_A_BAR for NEC and REM_A_MS for Sony. Test if one of these matches ADDRESS1ms
	movf	PROTOCOL,w		; if NEC, then
	btfss	STATUS,Z
	goto	SONY5
	movf	REM_A_BAR,w		; received remote address ms byte or complementary version of ls
	xorwf	ADDRESS5ms,w	; compare with stored
	btfsc	STATUS,Z
	goto	EQU_5			; correct 
	goto	CHNL6
SONY5
	movf	PROTOCOL,w		; if SONY 13 bit the requires comparison, if not 13 bit the values are 0
	xorlw	D'01'
	btfss	STATUS,Z
	goto	CHNL6
	movf	REM_A_MS,w		; received remote address ms byte or complementary version of ls
	xorwf	ADDRESS5ms,w	; compare with stored
	btfsc	STATUS,Z
	goto	EQU_5

CHNL6
; Channel 6
	movf	PROTOCOL,w
	btfss	STATUS,Z		; if NEC check repeat flag
	goto	NO_NEC6
	btfss	NEC_X,5			; if set then intitial code was for NEC_X,x (x=0 for Channel 1, 1 for Channel 2...)
	goto	NO_NEC6_R		; no repeat signal flag
	movf	TEMPS,w
	xorlw   H'88'			; if H88, a repeat signal
	btfsc	STATUS,Z
	goto	EQU_6			; repeat momentary for channel x, no extra checks required
NO_NEC6						; not NEC
NO_NEC6_R					; not NEC repeat signal
	clrf	NEC_X			; repeats off
	movf	PROTOCOL,w		; received protocol
	xorwf	PROTOCOL6,w		; stored protocol
	btfss	STATUS,Z		; check if the same
	goto	CHNL7			; check channel x+1
	movf	REMOTE_A,w		; received remote address ls byte
	xorwf	ADDRESS6ls,w	; compare with stored
	btfss	STATUS,Z
	goto	CHNL7			; check channel x+1

	movf	REMOTE_C,w		; received remote command
	xorwf	COMMAND6,w		; compare with stored
	btfss	STATUS,Z
	goto	CHNL7			; check channel x+1

; bypass if RC5
	movf	PROTOCOL,w
	xorlw	D'02'
	btfsc	STATUS,Z
	goto	EQU_6

; bypass if RC6
	movf	PROTOCOL,w
	xorlw	D'03'
	btfsc	STATUS,Z
	goto	EQU_6

; REM_A_BAR for NEC and REM_A_MS for Sony. Test if one of these matches ADDRESS1ms
	movf	PROTOCOL,w		; if NEC, then
	btfss	STATUS,Z
	goto	SONY6
	movf	REM_A_BAR,w		; received remote address ms byte or complementary version of ls
	xorwf	ADDRESS6ms,w	; compare with stored
	btfsc	STATUS,Z
	goto	EQU_6			; correct 
	goto	CHNL7
SONY6
	movf	PROTOCOL,w		; if SONY 13 bit the requires comparison, if not 13 bit the values are 0
	xorlw	D'01'
	btfss	STATUS,Z
	goto	CHNL6
	movf	REM_A_MS,w		; received remote address ms byte or complementary version of ls
	xorwf	ADDRESS6ms,w	; compare with stored
	btfsc	STATUS,Z
	goto	EQU_6

CHNL7
; Channel 7
	movf	PROTOCOL,w
	btfss	STATUS,Z		; if NEC check repeat flag
	goto	NO_NEC7
	btfss	NEC_X,6			; if set then intitial code was for NEC_X,x (x=0 for Channel 1, 1 for Channel 2...)
	goto	NO_NEC7_R		; no repeat signal flag
	movf	TEMPS,w
	xorlw   H'88'			; if H88, a repeat signal
	btfsc	STATUS,Z
	goto	EQU_7			; repeat momentary for channel x, no extra checks required
NO_NEC7						; not NEC
NO_NEC7_R					; not NEC repeat signal
	clrf	NEC_X			; repeats off
	movf	PROTOCOL,w		; received protocol
	xorwf	PROTOCOL7,w		; stored protocol
	btfss	STATUS,Z		; check if the same
	goto	CHNL8			; check channel x+1
	movf	REMOTE_A,w		; received remote address ls byte
	xorwf	ADDRESS7ls,w	; compare with stored
	btfss	STATUS,Z
	goto	CHNL8			; check channel x+1

	movf	REMOTE_C,w		; received remote command
	xorwf	COMMAND7,w		; compare with stored
	btfss	STATUS,Z
	goto	CHNL8			; check channel x+1

; bypass if RC5
	movf	PROTOCOL,w
	xorlw	D'02'
	btfsc	STATUS,Z
	goto	EQU_7

; bypass if RC6
	movf	PROTOCOL,w
	xorlw	D'03'
	btfsc	STATUS,Z
	goto	EQU_7

; REM_A_BAR for NEC and REM_A_MS for Sony. Test if one of these matches ADDRESS1ms
	movf	PROTOCOL,w		; if NEC, then
	btfss	STATUS,Z
	goto	SONY7
	movf	REM_A_BAR,w		; received remote address ms byte or complementary version of ls
	xorwf	ADDRESS7ms,w	; compare with stored
	btfsc	STATUS,Z
	goto	EQU_7			; correct 
	goto	CHNL8
SONY7
	movf	PROTOCOL,w		; if SONY 13 bit the requires comparison, if not 13 bit the values are 0
	xorlw	D'01'
	btfss	STATUS,Z
	goto	CHNL6
	movf	REM_A_MS,w		; received remote address ms byte or complementary version of ls
	xorwf	ADDRESS7ms,w	; compare with stored
	btfsc	STATUS,Z
	goto	EQU_7


CHNL8
; Channel 8
	movf	PROTOCOL,w
	btfss	STATUS,Z		; if NEC check repeat flag
	goto	NO_NEC8
	btfss	NEC_X,7			; if set then intitial code was for NEC_X,x (x=0 for Channel 1, 1 for Channel 2...)
	goto	NO_NEC8_R		; no repeat signal flag
	movf	TEMPS,w
	xorlw   H'88'			; if H88, a repeat signal
	btfsc	STATUS,Z
	goto	EQU_8			; repeat momentary for channel x, no extra checks required
NO_NEC8						; not NEC
NO_NEC8_R					; not NEC repeat signal
	clrf	NEC_X			; repeats off
	movf	PROTOCOL,w		; received protocol
	xorwf	PROTOCOL8,w		; stored protocol
	btfss	STATUS,Z		; check if the same
	goto	CHNLx			; check channel x+1
	movf	REMOTE_A,w		; received remote address ls byte
	xorwf	ADDRESS8ls,w	; compare with stored
	btfss	STATUS,Z
	goto	CHNLx			; check channel x+1

	movf	REMOTE_C,w		; received remote command
	xorwf	COMMAND8,w		; compare with stored
	btfss	STATUS,Z
	goto	CHNLx			; check channel x+1

; bypass if RC5
	movf	PROTOCOL,w
	xorlw	D'02'
	btfsc	STATUS,Z
	goto	EQU_8

; bypass if RC6
	movf	PROTOCOL,w
	xorlw	D'03'
	btfsc	STATUS,Z
	goto	EQU_8

; REM_A_BAR for NEC and REM_A_MS for Sony. Test if one of these matches ADDRESS1ms
	movf	PROTOCOL,w		; if NEC, then
	btfss	STATUS,Z
	goto	SONY8
	movf	REM_A_BAR,w		; received remote address ms byte or complementary version of ls
	xorwf	ADDRESS8ms,w	; compare with stored
	btfsc	STATUS,Z
	goto	EQU_8			; correct 
	goto	CHNLx
SONY8
	movf	PROTOCOL,w		; if SONY 13 bit the requires comparison, if not 13 bit the values are 0
	xorlw	D'01'
	btfss	STATUS,Z
	goto	CHNLx
	movf	REM_A_MS,w		; received remote address ms byte or complementary version of ls
	xorwf	ADDRESS8ms,w	; compare with stored
	btfsc	STATUS,Z
	goto	EQU_8

CHNLx	; end of channels. None matching
; after all channels 
	clrf	NEC_X			; NEC repeat flags clear if non match	
	goto	CHECK_S1

;..................................................................................................
EQU_1
; equal to channel 1
; check if momentary or toggle. TIMER_1 is set at zero for toggle

	movf	TIMER1,w
	btfss	STATUS,Z
	goto	MOM1
	btfss	PORTC,6			; toggle channel 1 on/off
	goto	SET_CH1
	bcf		PORTC,6			; CH1 LED
	goto	TOGL_DELAY
SET_CH1
	bsf		PORTC,6			; CH1 LED
	goto	TOGL_DELAY
MOM1; set timer	
	clrf	TMR2			; start from 0
	movf	TIMER1,w		; timer value
	movwf	TMR_1			; TIMER1 value
	bsf		PORTC,6			; CH1 LED

; if NEC code (protocol= 0) and for Momentary operation only
	movf	PROTOCOL1,w
	btfss	STATUS,Z
	goto	RPT_OFF
	bsf		NEC_X,0			; for momentary operation set NEC repeat flag for channel1. Bit 0 for channel 1
	goto	CHECK_S1

EQU_2
; equal to channel 2
; check if momentary or toggle. TIMER_2 is set at zero for toggle

	movf	TIMER2,w
	btfss	STATUS,Z
	goto	MOM2
	btfss	PORTC,7			; toggle channel x on/off
	goto	SET_CH2
	bcf		PORTC,7			; CHx LED
	goto	TOGL_DELAY
SET_CH2
	bsf		PORTC,7			; CHx LED
	goto	TOGL_DELAY
MOM2; set timer	
	clrf	TMR2			; start from 0
	movf	TIMER2,w		; timer value
	movwf	TMR_2			; TIMER2 value
	bsf		PORTC,7			; CH2 LED

; if NEC code (protocol= 0) and for Momentary operation only
	movf	PROTOCOL2,w
	btfss	STATUS,Z
	goto	RPT_OFF
	bsf		NEC_X,1			; for momentary operation set NEC repeat flag for channelx.  Bit 1 for Channel 2
	goto	CHECK_S1

EQU_3
; equal to channel 3
; check if momentary or toggle. TIMER_3 is set at zero for toggle

	movf	TIMER3,w
	btfss	STATUS,Z
	goto	MOM3
	btfss	PORTB,7			; toggle channel x on/off
	goto	SET_CH3
	bcf		PORTB,7			; CHx LED
	goto	TOGL_DELAY
SET_CH3
	bsf		PORTB,7			; CHx LED
	goto	TOGL_DELAY
MOM3; set timer	
	clrf	TMR2			; start from 0
	movf	TIMER3,w		; timer value
	movwf	TMR_3			; TIMERx value
	bsf		PORTB,7			; CHx LED

; if NEC code (protocol= 0) and for Momentary operation only
	movf	PROTOCOL3,w
	btfss	STATUS,Z
	goto	RPT_OFF
	bsf		NEC_X,2			; for momentary operation set NEC repeat flag for channelx. Bit set is channel -1 
	goto	CHECK_S1

EQU_4
; equal to channel 4
; check if momentary or toggle. TIMER_4 is set at zero for toggle

	movf	TIMER4,w
	btfss	STATUS,Z
	goto	MOM4
	btfss	PORTC,3			; toggle channel x on/off
	goto	SET_CH4
	bcf		PORTC,3			; CHx LED
	goto	TOGL_DELAY
SET_CH4
	bsf		PORTC,3			; CHx LED
	goto	TOGL_DELAY
MOM4; set timer	
	clrf	TMR2			; start from 0
	movf	TIMER4,w		; timer value
	movwf	TMR_4			; TIMERx value
	bsf		PORTC,3			; CHx LED

; if NEC code (protocol= 0) and for Momentary operation only
	movf	PROTOCOL4,w
	btfss	STATUS,Z
	goto	RPT_OFF
	bsf		NEC_X,3			; for momentary operation set NEC repeat flag for channelx. Bit set is channel -1
	goto	CHECK_S1

EQU_5
; equal to channel 5
; check if momentary or toggle. TIMER_5 is set at zero for toggle

	movf	TIMER5,w
	btfss	STATUS,Z
	goto	MOM5
	btfss	PORTC,4			; toggle channel x on/off
	goto	SET_CH5
	bcf		PORTC,4			; CHx LED
	goto	TOGL_DELAY
SET_CH5
	bsf		PORTC,4			; CHx LED
	goto	TOGL_DELAY
MOM5; set timer	
	clrf	TMR2			; start from 0
	movf	TIMER5,w		; timer value
	movwf	TMR_5			; TIMERx value
	bsf		PORTC,4			; CHx LED

; if NEC code (protocol =0) and for Momentary operation only
	movf	PROTOCOL5,w
	btfss	STATUS,Z
	goto	RPT_OFF
	bsf		NEC_X,4			; for momentary operation set NEC repeat flag for channelx. Bit set is channel -1
	goto	CHECK_S1

EQU_6
; equal to channel 6
; check if momentary or toggle. TIMER_6 is set at zero for toggle

	movf	TIMER6,w
	btfss	STATUS,Z
	goto	MOM6
	btfss	PORTC,5			; toggle channel x on/off
	goto	SET_CH6
	bcf		PORTC,5			; CHx LED
	goto	TOGL_DELAY
SET_CH6
	bsf		PORTC,5			; CHx LED
	goto	TOGL_DELAY
MOM6; set timer	
	clrf	TMR2			; start from 0
	movf	TIMER6,w		; timer value
	movwf	TMR_6			; TIMERx value
	bsf		PORTC,5			; CHx LED

; if NEC code (protocol= 0) and for Momentary operation only
	movf	PROTOCOL6,w
	btfss	STATUS,Z
	goto	RPT_OFF
	bsf		NEC_X,5			; for momentary operation set NEC repeat flag for channelx. Bit set is channel -1
	goto	CHECK_S1

EQU_7
; equal to channel 7
; check if momentary or toggle. TIMER_7 is set at zero for toggle

	movf	TIMER7,w
	btfss	STATUS,Z
	goto	MOM7
	btfss	PORTA,4			; toggle channel x on/off
	goto	SET_CH7
	bcf		PORTA,4			; CHx LED
	goto	TOGL_DELAY
SET_CH7
	bsf		PORTA,4			; CHx LED
	goto	TOGL_DELAY
MOM7; set timer	
	clrf	TMR2			; start from 0
	movf	TIMER7,w		; timer value
	movwf	TMR_7			; TIMERx value
	bsf		PORTA,4			; CHx LED

; if NEC code (protocol= 0) and for Momentary operation only
	movf	PROTOCOL7,w
	btfss	STATUS,Z
	goto	RPT_OFF
	bsf		NEC_X,6			; for momentary operation set NEC repeat flag for channelx. Bit set is channel -1
	goto	CHECK_S1

EQU_8
; equal to channel 8
; check if momentary or toggle. TIMER_8 is set at zero for toggle

	movf	TIMER8,w
	btfss	STATUS,Z
	goto	MOM8
	btfss	PORTA,5			; toggle channel x on/off
	goto	SET_CH8
	bcf		PORTA,5			; CHx LED
	goto	TOGL_DELAY
SET_CH8
	bsf		PORTA,5			; CHx LED
	goto	TOGL_DELAY
MOM8; set timer	
	clrf	TMR2			; start from 0
	movf	TIMER8,w		; timer value
	movwf	TMR_8			; TIMERx value
	bsf		PORTA,5			; CHx LED

; if NEC code (protocol= 0) and for Momentary operation only
	movf	PROTOCOL8,w
	btfss	STATUS,Z
	goto	RPT_OFF
	bsf		NEC_X,7			; for momentary operation set NEC repeat flag for channelx. Bit set is channel -1
	goto	CHECK_S1


; after all EQU_x's
RPT_OFF
	clrf	NEC_X			; if not NEC protocol, repeats off 
	goto	CHECK_S1

;/////////////////////////////////////////////////////////////////////////////
; independent
TOGL_DELAY ; include a delay between toggling on and off

	call	DELAY100
	call	DELAY100
	call	DELAY100
	goto	CHECK_S1 

SHOW_VR1 ; timer adjustment 125ms to 32s. Shows VR1 setting as 16 level bargraph on LEDs1-8

; read VR1
	movlb	D'1'			; bank1	ADCON0/1/2
	movlw 	B'00010100'		; AN5 VR1 Timer for momentary on period	
	movwf	ADCON0
	movlw	B'00010000'		; left justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON		; A/D on
	call	ACQUIRE_AD		; value in w loaded from ADRESH has 8-bit a/d value
	movwf	TEMPS			; store VR1
	lsrf	TEMPS,f
	lsrf	TEMPS,f
	lsrf	TEMPS,f
	lsrf	TEMPS,f

	movf	TEMPS,w			; if set at 0 light Ack.LED
	movlw	B'00000000'		; initially 0
	btfsc	STATUS,Z
	movlw	B'00000100'		; Ack. LED on for lowest timeout
	movwf	PORTC
; clear channel LEDs
	clrf	PORTA
	clrf	PORTB

; set LED when bit is high from TEMPS

; show 0-15 as a bargraph on channel LEDs
	movf	TEMPS,w
	btfsc	STATUS,Z		; when zero, no Channel LEDs on
	goto	END_DISP
	decfsz	TEMPS,f
	goto	NO_BAR1
	bsf		PORTC,6
	goto	END_DISP
NO_BAR1
	decfsz	TEMPS,f
	goto	NO_BAR2
	bsf		PORTC,6
	nop		
	bsf		PORTC,7
	goto	END_DISP
NO_BAR2
	decfsz	TEMPS,f
	goto	NO_BAR3
	bsf		PORTC,7
	goto	END_DISP
NO_BAR3
	decfsz	TEMPS,f
	goto	NO_BAR4
	bsf		PORTC,7
	bsf		PORTB,7
	goto	END_DISP
NO_BAR4
	decfsz	TEMPS,f
	goto	NO_BAR5
	bsf		PORTB,7
	goto	END_DISP
NO_BAR5
	decfsz	TEMPS,f
	goto	NO_BAR6
	bsf		PORTB,7
	bsf		PORTC,3
	goto	END_DISP
NO_BAR6
	decfsz	TEMPS,f
	goto	NO_BAR7
	bsf		PORTC,3
	goto	END_DISP
NO_BAR7
	decfsz	TEMPS,f
	goto	NO_BAR8
	bsf		PORTC,3
	nop
	bsf		PORTC,4
	goto	END_DISP
NO_BAR8
	decfsz	TEMPS,f
	goto	NO_BAR9
	bsf		PORTC,4
	goto	END_DISP
NO_BAR9
	decfsz	TEMPS,f
	goto	NO_BAR10
	bsf		PORTC,4
	nop
	bsf		PORTC,5
	goto	END_DISP
NO_BAR10
	decfsz	TEMPS,f
	goto	NO_BAR11
	bsf		PORTC,5		
	goto	END_DISP
NO_BAR11
	decfsz	TEMPS,f
	goto	NO_BAR12
	bsf		PORTA,4
	bsf		PORTC,5
	goto	END_DISP
NO_BAR12
	decfsz	TEMPS,f
	goto	NO_BAR13
	bsf		PORTA,4
	goto	END_DISP
NO_BAR13
	decfsz	TEMPS,f
	goto	NO_BAR14
	bsf		PORTA,5
	nop
	bsf		PORTA,4
	goto	END_DISP
NO_BAR14
	bsf		PORTA,5

END_DISP

; check S3 when open end of dot display
; if closed, loop to SHOW_VR1
	call	DELAY100
	btfss	PORTA,1			; if S3 still pressed loop to show VR1 setting
	goto	SHOW_VR1
; restore indicators for channel
	movf	PORTC_STO,w		; portc store
	movwf	PORTC
	movf	PORTB_STO,w		; portb store
	movwf	PORTB
	movf	PORTA_STO,w		; porta store
	movwf	PORTA
	bsf		PORTC,2
	bsf		PORTB,4
	return
;...........................................................................................
; programming/learning mode
PGLM
	bsf		MODE,0			; learn mode
; light ACK LED
	bsf		PORTC,2
	call	CALX			; calibrate oscillator

PROGRAM_MODE
; PROGRAM mode where IR code is read and referenced against the selected channel for programming

	call	CHANNEL			; select channel
	call	READ_VR1		; get VR1 value
	goto	CHK_S1x


; subroutine
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
CHANNEL ; subroutine to determine the selected channel.

; reset timeout
	movlw	D'160'			; 20s timeout (125ms per value)
	movwf	TIMEOUT

; output or switch value
	movlw	B'00000111'
	andwf	PORTC,f			; PORTC LEDs off 
	bcf		PORTA,5			; PORTA LED
	bcf		PORTB,7			; PORTB LED
	bcf		PORTA,4			; PORTA LED
; clear timers
	clrf	TMR_1
	clrf	TMR_2
	clrf	TMR_3
	clrf	TMR_4
	clrf	TMR_5
	clrf	TMR_6
	clrf	TMR_7
	clrf	TMR_8

	movf	SW_VAL,w		; counts up to 8. Counts up each time S2 pressed to record code
 	xorlw	D'0'	
	btfsc	STATUS,Z		; if zero then Channel 1
	bsf		PORTC,6			; light channel 1 LED

	movf	SW_VAL,w		; counts up to 8. Counts up each time S2 pressed to record code
 	xorlw	D'1'	
	btfsc	STATUS,Z		; if = then Channel 2
	bsf		PORTC,7			; light channel 2 LED
		
	movf	SW_VAL,w		; counts up to 8. Counts up each time S2 pressed to record code
 	xorlw	D'2'	
	btfsc	STATUS,Z		; if = then Channel 3
	bsf		PORTB,7			; light channel 3 LED
		
	movf	SW_VAL,w		; counts up to 8. Counts up each time S2 pressed to record code
 	xorlw	D'3'	
	btfsc	STATUS,Z		; if = then Channel 4
	bsf		PORTC,3			; light channel 4 LED
		
	movf	SW_VAL,w		; counts up to 8. Counts up each time S2 pressed to record code
 	xorlw	D'4'	
	btfsc	STATUS,Z		; if = then Channel 5
	bsf		PORTC,4			; light channel 5 LED

	movf	SW_VAL,w		; counts up to 8. Counts up each time S2 pressed to record code
 	xorlw	D'5'	
	btfsc	STATUS,Z		; if = then Channel 6
	bsf		PORTC,5			; light channel 6 LED

	movf	SW_VAL,w		; counts up to 8. Counts up each time S2 pressed to record code
 	xorlw	D'6'	
	btfsc	STATUS,Z		; if = then Channel 7
	bsf		PORTA,4			; light channel 7 LED

	movf	SW_VAL,w		; counts up to 8. Counts up each time S2 pressed to record code
 	xorlw	D'7'	
	btfsc	STATUS,Z		; if = then Channel 8
	bsf		PORTA,5			; light channel 8 LED
	return

;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

CHK_S1x
	call	DELAY100		; 100ms delay
; wait for check if S1 open
	btfss	PORTB,5			; S1, if high, open 
	goto	CHK_S1x

; check S2
OPERATION

	call	CALX			; calibrate oscillator
	call	READ_VR1_1		; get VR1 value

	movf	TIMEOUT,w
	btfss	STATUS,Z		; when zero exit program mode
	goto	IF_S2
; restore status
RESTORE
	clrf	PORTA
	clrf	PORTB
	clrf	PORTC
	clrf	MOM_TOG
	goto	CHECK_S1

;;;;;;;;;;;;;;;;;;;;;;;

IF_S2
	
; if S2 select next channel
	btfss	PORTB,6
	goto	NEXT_CHAN		; next channel select

; if S3 pressed alternate between toggle and momentary
	btfss	PORTA,1			; switch S3
	goto	SET_DELAY

	btfss	PORTB,5			; if S1 pressed run IR code read
	goto	IR_IN			; wait for IR code
	goto	OPERATION

NEXT_CHAN
	incf	SW_VAL,f
	movf	SW_VAL,w
	xorlw	D'8'			; if 8 then set at zero again
	btfsc	STATUS,Z
	clrf	SW_VAL	
	call	CHANNEL
; wait for S2 open
CHK_S2
	call	DELAY100
	call	DELAY100
	btfss	PORTB,6
	goto	CHK_S2
	goto	OPERATION

SET_DELAY
; reset timeout (20s)
	movlw	D'160'			; 125ms per value
	movwf	TIMEOUT
	call	READ_VR1		; read VR1 and place timer value in channel TIMERx (x=1-8)
	goto	CHK_S3			; wait for S3 to open

; SW_VAL has channel number 0-7
; if VR1 is 0 then toggle
; if VR1 is >0 then momentary delay


; read VR1
; subroutine
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
READ_VR1
	movlb	D'1'			; bank1	ADCON0/1/2
	movlw 	B'00010100'		; AN5 VR1 Timer for momentary on period	
	movwf	ADCON0
	movlw	B'00010000'		; left justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON		; A/D on
	call	ACQUIRE_AD		; value in w loaded from ADRESH has 8-bit a/d value
	movwf	TEMPS			; store VR1
; divide by 16 for 0-15 values
	lsrf	TEMPS,f
	lsrf	TEMPS,f
	lsrf	TEMPS,f
	lsrf	TEMPS,f
	movf	TEMPS,w
	call	TMR_TBL			; look up timer values from 0-15 values in w
	movwf	TIMER_TEMP

; Momentary/ toggle
	btfsc	MOM_TOG,0		; if set then clear	
	goto	SET4
	
	bsf		MOM_TOG,0		; momentary or toggle
	movlw	B'00000101'
	movwf	FLASH_T			; flash timer
	bcf		PORTB,4			; Momentary/toggle LED
	return
SET4
	clrf	TIMER_TEMP		; clear when Mom/Toggle off
	bsf		PORTB,4
	clrf	MOM_TOG
	return

TMR_TBL ; alters the 0-15 values to various time periods from 125ms to 32s
	brw		
	retlw	D'1'			; 1=125ms
	retlw	D'2'			; 250ms
	retlw	D'3'			; 375ms
	retlw	D'4'			; 500ms
	retlw	D'5'			; 625ms
	retlw	D'6'			; 750ms
	retlw   D'7'			; 875ms
	retlw	D'8'			; 1s
	retlw	D'15'			; 2s
	retlw	D'24'			; 3s
	retlw	D'32'			; 4s
	retlw	D'40'			; 5s
	retlw	D'48'			; 6s
	retlw	D'63'			; 8s
	retlw	D'127'			; 16s
	retlw	D'255'			; 32s

READ_VR1_1
	movlb	D'1'			; bank1	ADCON0/1/2
	movlw 	B'00010100'		; AN5 VR1 Timer for momentary on period	
	movwf	ADCON0
	movlw	B'00010000'		; left justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON		; A/D on
	call	ACQUIRE_AD		; value in w loaded from ADRESH has 8-bit a/d value
	movwf	TEMPS			; store VR1
; divide by 16 for 0-15 values
	lsrf	TEMPS,f
	lsrf	TEMPS,f
	lsrf	TEMPS,f
	lsrf	TEMPS,f
	movf	TEMPS,w
	call	TMR_TBL			; look up timer values from 0-15 values in w
	movwf	TIMER_TEMP
	movf	MOM_TOG,w
	btfsc	STATUS,Z
	clrf	TIMER_TEMP		; clear when Mom/Toggle off
	return
	
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

CHK_S3
; wait for S3 open
	call	DELAY100
	call	DELAY100
	btfsc	PORTA,1			; S3
	goto	OPERATION
	call	DELAY100
	call	DELAY100
	btfsc	PORTA,1			; S3
	goto	OPERATION
	call	DELAY100
	call	DELAY100
	btfsc	PORTA,1			; S3
	goto	OPERATION
; if closed for 600ms then show VR1 setting
; store LED indicators on or off
	movf	PORTA,w
	movwf	PORTA_STO 
	movf	PORTB,w
	movwf	PORTB_STO
	movf	PORTC,w
	movwf	PORTC_STO

SHW
; reset timeout
	movlw	D'160'			; 20s timeout (125ms per value)
	movwf	TIMEOUT

	call	SHOW_VR1
	btfss	PORTA,1			; S3
	goto	SHW	
	bsf		MOM_TOG,0		; momentary 
	goto	OPERATION

; wait for valid IR code reception
IR_IN
	bcf		PORTB,4			; mom toggle LED off
	clrf	MOM_TOG			; stops flashing
	bcf		PORTC,2			; Ack LED off
	bsf		ACK_FLASH,0		; when set no ACK LED

; ACK flash while waiting for signal
	bsf		FLASH_ACK,0		; flag set for flash
	movlw	B'00001100'		; preload flash timer so flashes soon after 
	movwf	FLASH_T			; flash timer
	bcf		PORTC,2	
	call	START			; if returns with 00 or FF then not valid. (A0 for 'A o'k is valid code)
	clrf	FLASH_ACK
		; 
	nop						; avoid interrupt clashing
	bcf		PORTC,2			; ACK LED off
	movwf	TEMPS

; compare w with H'0F'. If so S1 was pressed
	movf	TEMPS,w			; 'w' has response from IR reception. Store value
	xorlw	H'0F'			; S1 pressed if H0F
	btfsc	STATUS,Z
	goto	CHECK_S1 
;  compare 'w' against H'A0'
	movf	TEMPS,w
	xorlw	H'A0'
	btfsc	STATUS,Z
	goto	VALID			; valid code so store

; switch off Channel  LEDs

; all LEDs off
	clrf	RCV_ACK	
	bcf		PORTA,5 	   	; all LEDs off first
	bcf		PORTB,7
	clrf	PORTC			;
	bcf		PORTA,4
	clrf	MOM_TOG
	bcf		PORTB,4			; momentary/toggle LED off
	goto	CHECK_S1

VALID
; code is valid

; show protocol. One momentary flash=NEC, Two momentary flash=Sony, Three momentary flash=RC5, Four momentary flash=RC6
; wait for S1 to close

	
; only run this once	

	call	DELAY100		;  100ms	
	call	DELAY100
	movf	PROTOCOL,w
	andlw	B'00001111'		; only ls bits
	movwf	TEMP
	xorlw	D'11'			; Sony 8-bit address
	btfsc	STATUS,Z
	goto	FLASH_OFF2
	movf	TEMP,w
	xorlw	D'21'			; sony 13-bit address
	btfsc	STATUS,Z
	goto	FLASH_OFF2
	movf	TEMP,w
	xorlw	D'1'			; sony 5-bit address
	btfsc	STATUS,Z
	goto	FLASH_OFF2
	movf	TEMP,w
	xorlw	D'2'			; RC5
	btfsc	STATUS,Z
	goto	FLASH_OFF3
	movf	TEMP,w
	xorlw	D'3'			; RC6
	btfss	STATUS,Z
	goto	FLASH_OFF1		; NEC
FLASH_OFF4
	bcf	 	PORTC,2
	call	DELAY_XTRA
	bsf	 	PORTC,2
	call	DELAY_XTRA
FLASH_OFF3
	bcf	 	PORTC,2
	call	DELAY_XTRA
	bsf	 	PORTC,2
	call	DELAY_XTRA
FLASH_OFF2
	bcf	 	PORTC,2				; LED off
	call	DELAY_XTRA
 	bsf	 	PORTC,2				; LED on
	call	DELAY_XTRA
FLASH_OFF1
	bcf	 	PORTC,2				; LED off
	call	DELAY_XTRA
 	bsf	  	PORTC,2				; LED on
	call	DELAY_XTRA
	bcf		PORTC,2

; store in flash
	call	LOAD_CH_DATA
	goto	FLASH_STO

; subroutine
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
LOAD_CH_DATA
; load into required channel timer TIMER1 to TIMER8
	movf	SW_VAL,w
	btfsc	STATUS,Z		; if zero load data into channel1
	goto	TX1
	movf	SW_VAL,w
	xorlw	D'1'
	btfsc	STATUS,Z		; if equal load data into channel2
	goto	TX2
	movf	SW_VAL,w
	xorlw	D'2'
	btfsc	STATUS,Z		; if equal load data into channel3
	goto	TX3
	movf	SW_VAL,w
	xorlw	D'3'
	btfsc	STATUS,Z		; if equal load data into channel4
	goto	TX4
	movf	SW_VAL,w
	xorlw	D'4'
	btfsc	STATUS,Z		; if equal load data into channel5
	goto	TX5
	movf	SW_VAL,w
	xorlw	D'5'
	btfsc	STATUS,Z		; if equal load data into channel6
	goto	TX6
	movf	SW_VAL,w
	xorlw	D'6'
	btfsc	STATUS,Z		; if equal load data into channel7
	goto	TX7
	movf	SW_VAL,w
TX8							; load data into channel8
	movf	TIMER_TEMP,w
	movwf	TIMER8
	; Channel data
	movf	PROTOCOL,w		; protocol
	movwf	PROTOCOL8		; Protocol is least significant 4-bits 
; 0 = NEC, 1 = Sony;  2 = RC5; 3 = RC6. Plus for Sony, the address length is in ms 4-bits 0= 5-bits, 1 = 8 bits, 2 = 13bits
	movf	REMOTE_A,w		; remote control Address byte
	movwf	ADDRESS8ls		; IR code address ls byte
; if PROTOCOL is Sony then load address ADDRESSyls with ms bytes from REM_A_MS. 
; compare with 01 in protocol for Sony , 13bit address if used compared
	movf	PROTOCOL,w		; if =, then
	xorlw	D'01'
	btfss	STATUS,Z
	goto	NEC_8Y
	movf	REM_A_MS,w
	movwf	ADDRESS8ms		; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
	goto	CHAN8
NEC_8Y ; check if NEC
	movf	PROTOCOL,w		; if =, then
	xorlw	D'00'
	btfss	STATUS,Z
	goto	CHAN8
	movf	REM_A_BAR,w
	movwf	ADDRESS8ms		; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
CHAN8
	movf	REMOTE_C,w		; command value
	movwf	COMMAND8		; IR code command
	return

TX1
	movf	TIMER_TEMP,w
	movwf	TIMER1
; Channel data
	movf	PROTOCOL,w		; protocol
	movwf	PROTOCOL1		; Protocol is least significant 4-bits 
; 0 = NEC, 1 = Sony;  2 = RC5; 3 = RC6. Plus for Sony, the address length is in ms 4-bits 0= 5-bits, 1 = 8 bits, 2 = 13bits
	movf	REMOTE_A,w		; remote control Address byte
	movwf	ADDRESS1ls		; IR code address ls byte
; if PROTOCOL is Sony then load address ADDRESSyls with ms bytes from REM_A_MS. 
; compare with 01 in protocol for Sony , 13bit address if used compared
	movf	PROTOCOL,w		; if =, then
	xorlw	D'01'
	btfss	STATUS,Z
	goto	NEC_1Y
	movf	REM_A_MS,w
	movwf	ADDRESS1ms		; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
	goto	CHAN1
NEC_1Y ; check if NEC
	movf	PROTOCOL,w		; if =, then
	xorlw	D'00'
	btfss	STATUS,Z
	goto	CHAN1
	movf	REM_A_BAR,w
	movwf	ADDRESS1ms		; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
CHAN1
	movf	REMOTE_C,w		; command value
	movwf	COMMAND1		; IR code command 1
	return

TX2
	movf	TIMER_TEMP,w
	movwf	TIMER2
; Channel data
	movf	PROTOCOL,w		; protocol
	movwf	PROTOCOL2		; Protocol is least significant 4-bits 
; 0 = NEC, 1 = Sony;  2 = RC5; 3 = RC6. Plus for Sony, the address length is in ms 4-bits 0= 5-bits, 1 = 8 bits, 2 = 13bits
	movf	REMOTE_A,w		; remote control Address byte
	movwf	ADDRESS2ls		; IR code address ls byte
; if PROTOCOL is Sony then load address ADDRESSyls with ms bytes from REM_A_MS. 
; compare with 01 in protocol for Sony , 13bit address if used compared
	movf	PROTOCOL,w		; if =, then
	xorlw	D'01'
	btfss	STATUS,Z
	goto	NEC_2Y
	movf	REM_A_MS,w
	movwf	ADDRESS2ms		; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
	goto	CHAN2
NEC_2Y ; check if NEC
	movf	PROTOCOL,w		; if =, then
	xorlw	D'00'
	btfss	STATUS,Z
	goto	CHAN2
	movf	REM_A_BAR,w
	movwf	ADDRESS2ms		; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
CHAN2
	movf	REMOTE_C,w		; command value
	movwf	COMMAND2		; IR code command
	return

TX3
	movf	TIMER_TEMP,w
	movwf	TIMER3
; Channel data
	movf	PROTOCOL,w		; protocol
	movwf	PROTOCOL3		; Protocol is least significant 4-bits 
; 0 = NEC, 1 = Sony;  2 = RC5; 3 = RC6. Plus for Sony, the address length is in ms 4-bits 0= 5-bits, 1 = 8 bits, 2 = 13bits
	movf	REMOTE_A,w		; remote control Address byte
	movwf	ADDRESS3ls		; IR code address ls byte
; if PROTOCOL is Sony then load address ADDRESSyls with ms bytes from REM_A_MS. 
; compare with 01 in protocol for Sony , 13bit address if used compared
	movf	PROTOCOL,w		; if =, then
	xorlw	D'01'
	btfss	STATUS,Z
	goto	NEC_3Y
	movf	REM_A_MS,w
	movwf	ADDRESS3ms		; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
	goto	CHAN3
NEC_3Y ; check if NEC
	movf	PROTOCOL,w		; if =, then
	xorlw	D'00'
	btfss	STATUS,Z
	goto	CHAN3
	movf	REM_A_BAR,w
	movwf	ADDRESS3ms		; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
CHAN3
	movf	REMOTE_C,w		; command value
	movwf	COMMAND3		; IR code command
	return

TX4
	movf	TIMER_TEMP,w
	movwf	TIMER4
; Channel data
	movf	PROTOCOL,w		; protocol
	movwf	PROTOCOL4		; Protocol is least significant 4-bits 
; 0 = NEC, 1 = Sony;  2 = RC5; 3 = RC6. Plus for Sony, the address length is in ms 4-bits 0= 5-bits, 1 = 8 bits, 2 = 13bits
	movf	REMOTE_A,w		; remote control Address byte
	movwf	ADDRESS4ls		; IR code address ls byte
; if PROTOCOL is Sony then load address ADDRESSyls with ms bytes from REM_A_MS. 
; compare with 01 in protocol for Sony , 13bit address if used compared
	movf	PROTOCOL,w		; if =, then
	xorlw	D'01'
	btfss	STATUS,Z
	goto	NEC_4Y
	movf	REM_A_MS,w
	movwf	ADDRESS4ms		; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
	goto	CHAN4
NEC_4Y ; check if NEC
	movf	PROTOCOL,w		; if =, then
	xorlw	D'00'
	btfss	STATUS,Z
	goto	CHAN4
	movf	REM_A_BAR,w
	movwf	ADDRESS4ms		; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
CHAN4
	movf	REMOTE_C,w		; command value
	movwf	COMMAND4		; IR code command
	return

TX5
	movf	TIMER_TEMP,w
	movwf	TIMER5
; Channel data
	movf	PROTOCOL,w		; protocol
	movwf	PROTOCOL5		; Protocol is least significant 4-bits 
; 0 = NEC, 1 = Sony;  2 = RC5; 3 = RC6. Plus for Sony, the address length is in ms 4-bits 0= 5-bits, 1 = 8 bits, 2 = 13bits
	movf	REMOTE_A,w		; remote control Address byte
	movwf	ADDRESS5ls		; IR code address ls byte
; if PROTOCOL is Sony then load address ADDRESSyls with ms bytes from REM_A_MS. 
; compare with 01 in protocol for Sony , 13bit address if used compared
	movf	PROTOCOL,w		; if =, then
	xorlw	D'01'
	btfss	STATUS,Z
	goto	NEC_5Y
	movf	REM_A_MS,w
	movwf	ADDRESS5ms		; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
	goto	CHAN5
NEC_5Y ; check if NEC
	movf	PROTOCOL,w		; if =, then
	xorlw	D'00'
	btfss	STATUS,Z
	goto	CHAN5
	movf	REM_A_BAR,w
	movwf	ADDRESS5ms		; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
CHAN5
	movf	REMOTE_C,w		; command value
	movwf	COMMAND5		; IR code command
	return

TX6
	movf	TIMER_TEMP,w
	movwf	TIMER6
; Channel data
	movf	PROTOCOL,w		; protocol
	movwf	PROTOCOL6		; Protocol is least significant 4-bits 
; 0 = NEC, 1 = Sony;  2 = RC5; 3 = RC6. Plus for Sony, the address length is in ms 4-bits 0= 5-bits, 1 = 8 bits, 2 = 13bits
	movf	REMOTE_A,w		; remote control Address byte
	movwf	ADDRESS6ls		; IR code address ls byte
; if PROTOCOL is Sony then load address ADDRESSyls with ms bytes from REM_A_MS. 
; compare with 01 in protocol for Sony , 13bit address if used compared
	movf	PROTOCOL,w		; if =, then
	xorlw	D'01'
	btfss	STATUS,Z
	goto	NEC_6Y
	movf	REM_A_MS,w
	movwf	ADDRESS6ms		; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
	goto	CHAN6
NEC_6Y ; check if NEC
	movf	PROTOCOL,w		; if =, then
	xorlw	D'00'
	btfss	STATUS,Z
	goto	CHAN6
	movf	REM_A_BAR,w
	movwf	ADDRESS6ms		; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
CHAN6
	movf	REMOTE_C,w		; command value
	movwf	COMMAND6		; IR code command
	return

TX7
	movf	TIMER_TEMP,w
	movwf	TIMER7
; Channel data
	movf	PROTOCOL,w		; protocol
	movwf	PROTOCOL7		; Protocol is least significant 4-bits 
; 0 = NEC, 1 = Sony;  2 = RC5; 3 = RC6. Plus for Sony, the address length is in ms 4-bits 0= 5-bits, 1 = 8 bits, 2 = 13bits
	movf	REMOTE_A,w		; remote control Address byte
	movwf	ADDRESS7ls		; IR code address ls byte
; if PROTOCOL is Sony then load address ADDRESSyls with ms bytes from REM_A_MS. 
; compare with 01 in protocol for Sony , 13bit address if used compared
	movf	PROTOCOL,w		; if =, then
	xorlw	D'01'
	btfss	STATUS,Z
	goto	NEC_7Y
	movf	REM_A_MS,w
	movwf	ADDRESS7ms		; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
	goto	CHAN7
NEC_7Y ; check if NEC
	movf	PROTOCOL,w		; if =, then
	xorlw	D'00'
	btfss	STATUS,Z
	goto	CHAN7
	movf	REM_A_BAR,w
	movwf	ADDRESS7ms		; IR code address used as ms byte for Sony 20bit data (13bit address) ie 5 ms bits and NEC address extension
CHAN7
	movf	REMOTE_C,w		; command value
	movwf	COMMAND7		; IR code command
	return

;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

FLASH_STO
; write to flash in 32 byte steps
; first 32 bytes H1F80-1F9F
	movlw	H'1F'
	movwf	READADDMS		; MS Byte of Program Address to write
	movlw	H'80'	
	movwf	READADDLS 		; LS Byte of Program Address to write
; initial RAM location (H2028)
	movlw	H'20'
	movwf	FSR0H			; ms byte
	movlw	H'28'	
	movwf	FSR0L
	call	WRITE			; write to flash memory

; second 32 bytes. H1FA0-
	movlw	H'1F'
	movwf	READADDMS		; MS Byte of Program Address to write
	movlw	H'A0'	
	movwf	READADDLS 		; LS Byte of Program Address to write
; initial RAM location (H2048)
	movlw	H'20'
	movwf	FSR0H			; ms byte
	movlw	H'48'	
	movwf	FSR0L
	call	WRITE			; write to flash memory

; clear LEDs
; all LEDs off

	bcf		PORTA,5 	   	; all LEDs off first
	bcf		PORTB,7
	clrf	PORTC			;
	bcf		PORTA,4
	clrf	MOM_TOG
	bcf		PORTB,4			; momentary/toggle LED off

	goto	CHECK_S1




; subroutines
; *****************************************************************************************************************************************************

ACQUIRE_AD
; wait >20us to charge input capacitance
	movlw	D'11'
	movwf	TEMP
WAIT2
	decfsz	TEMP,f
	goto	WAIT2	
	bsf		ADCON0,1		; GO/DONE bit start conversion
WAIT_CONV2
	btfsc	ADCON0,1		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV2
	movf	ADRESH,w
	movlb	D'0'			; bank 0
	return
;.................................................

; delay loop 
DELAY100 ; approx 100ms
	movlw	D'255'			; delay value
DELAY_SET
	movwf	STORE1			; STORE1 is number of loops value
LOOP800	
	movlw	D'213'
	movwf	STORE2			; STORE2 is internal loop value	
LOOP900
	decfsz	STORE2,f
	goto	LOOP900
	decfsz	STORE1,f
	goto	LOOP800
	return

DELAY_XTRA
	movlw	D'5'
	movwf	DLY_XTN
LOOP1000
	call	DELAY100
	decfsz	DLY_XTN,f
	goto	LOOP1000
	return

;........................................

; read data memory
READ; 'w' has read data
	movf	INTCON,w		; store GIE setting bit 7
	movwf	INTCON_STORE
	bcf		INTCON,GIE 		; Disable interrupts
	movlb	D'3'			; bank 3 
	movf	READADDMS,w 
	movwf 	PMADRH			; ms Byte of Program Address to read
	movf	READADDLS,w
	movwf 	PMADRL 			; ls Byte of Program Address to read
	bcf		PMCON1,CFGS		; avoid configuration space
	bsf	 	PMCON1,RD 		; Read
	nop 					
	nop
; memory is read in second cycle PM read instruction
	movf	PMDATH,w 		; ms Byte of Program data 
	movwf	TEMP_VAL
	movf	PMDATL,w 		; ls Byte of Program data in 'w'
	movlb	D'0'			; bank 0
	btfsc	INTCON_STORE,7	; if set then set GIE
	bsf		INTCON,GIE		; re-enable interrupts 
	return
;.............................................

; write to data memory
WRITE
	clrf	LOOPS			; counter
	movf	INTCON,w
	movwf	INTCON_STORE	; store GIE (bit7)
	bcf		INTCON,GIE 		; Disable interrupts so required sequences will execute properly
; load write latches
	movlb	D'03'			; bank 3
	movf	READADDMS,W		; Load upper 6 bits of address boundary			
	movwf	PMADRH 			;
	movf	READADDLS,W 	; Load lower 8 bits of erase address boundary
	andlw	B'11110000'		; clear ls bits to start of ID memory
	movwf	PMADRL 			;

; erase first
	bcf		PMCON1,CFGS 	; Not configuration space
	bsf		PMCON1,FREE 	; Specify an erase operation
	bsf		PMCON1,WREN 	; Enable writes
	movlw	H'55'			; Start of required write sequence:
	movwf	PMCON2 			; Write 55h
	movlw	H'AA' 			;
	movwf	PMCON2 			; Write AAh
	bsf		PMCON1,WR 		; Set WR bit to begin erase
	nop					 	; NOP instructions are forced as processor writes all the program memory write latches simultaneously to program memory.
	nop	 
	bcf		PMCON1,WREN 	; Disable writes

; load latches
	movf	READADDMS,W		; Load upper 6 bits of  address boundary			
	movwf	PMADRH			;
	movf	READADDLS,W 	; Load lower 8 bits of erase address boundary
	andlw	B'11110000'		; clear ls bits to start of ID memory
	movwf	PMADRL 			;

	bcf		PMCON1,CFGS		; Not configuration space
	bsf		PMCON1,WREN	 	; Enable writes
	bsf	    PMCON1,LWLO 	; Only Load Write Latches

LOOPW
	moviw	FSR0++ 			; Load first data byte into lower
	movwf	PMDATL 			;
	movlw	H'3F'	 		; Load second data byte into upper
	movwf	PMDATH 			;

	movf 	LOOPS,w		 	; Check lower bits of address
	xorlw	0x1F			; Check if we're on the last of 32 addresses
;	andlw	0x1F ;
	btfsc	STATUS,Z 		; Exit if last of 32 words,
	goto	START_WRITE 	;

	movlw	H'55'		 	; Start of required write sequence:
	movwf	PMCON2 			; Write 55h
	movlw	H'AA' ;
	movwf	PMCON2			; Write AAh
	bsf		PMCON1,WR 		; Set WR bit to begin write
	nop					 	; nop instructions are forced as processor loads program memory write latches
	nop ;
	incf	PMADRL,f	 	; Still loading latches Increment address
	incf	LOOPS,f
	goto	LOOPW

START_WRITE ; write
	bcf		PMCON1,LWLO		; No more loading latches - Start Flash program
; memory write
	movlw	H'55'			; Start of required write sequence:
	movwf	PMCON2 			; Write 55h
	movlw	H'AA' ;
	movwf	PMCON2 			; Write AAh
	bsf		PMCON1,WR 		; Set WR bit to begin write
	nop						; NOP instructions are forced as processor writes all the program memory write latches simultaneously to program memory.
	nop	  
	bcf		PMCON1,WREN 	; Disable writes
	movlb	D'0'

	btfsc	INTCON_STORE,7	; if set then set GIE
	bsf		INTCON,GIE		; re-enable interrupts 
	return

; *****************************************************************************************************************************************************
; Read IR codes

; IR subroutines

START ; start of Infra Red reception (usage: Call START if returns with 00 or FF then not valid. A0 for A ok is valid code)
; wait for start with PORTA,0 low
; if learn/program mode check if S1 open

	movf	MODE,w			; if clear then receive mode
	btfsc	STATUS,Z
	goto 	START1

; wait until S1 is open
WX	
	call	DELAY100
	btfss	PORTB,5
	goto	WX

START1
; timeout only during program/learning mode
	btfss	MODE,0
	goto	RCV				; receive
	movf	TIMEOUT,w
	btfsc	STATUS,Z		; when zero exit program mode
	retlw	D'00'

RCV ; receive
	btfss	PORTA,0			; IR receiver signal 
	goto	STARTX

; if S1 is pressed return to beginning for learning mode
	btfsc	PORTB,5
	goto	START1		;
	call	DELAY100
	btfsc	PORTB,5
	goto	START1
	retlw	H'0F'			; flag that S1 is pressed

STARTX
	bsf		RCV_ACK,0		; Ack LED can flash
	btfss	ACK_FLASH,0
	bsf		PORTC,2
		
; Clear timer1
	bcf		T1CON,0			; timer stopped
	clrf	TMR1L			; 1us counter
	clrf	TMR1H
	bsf		T1CON,0		 	; start timer

; Timer1 increments at 1us rate. 

; wait for a high at PORTA,0. when high, test the time period
W1	btfss	PORTA,0
	goto	W1

RECEIVE_STRT
; NEC is 9ms low (modulated signal received)
; Sony is 2.4ms low
; RC5 is 889us low
; RC6 is 2.666ms low

; test for RC5 ; test for 889us. Range allows 10% at between 800us and 977us
	bcf		T1CON,0	; stop timer and read
;  is it >800us
	movf	TMR1H,w			;
	sublw	H'3'			 
	movwf	TEMP
	movf	TMR1L,w
	sublw	H'20'			; 
	btfss	STATUS,C
	decf	TEMP,f
	btfss	TEMP,7		
	retlw	D'00'			; less than 800us so not an IR code
; is it <977us
	movf	TMR1H,w			;
	sublw	H'03'			 
	movwf	TEMP
	movf	TMR1L,w
	sublw	H'D1'			; 
	btfss	STATUS,C
	decf	TEMP,f
	btfss	TEMP,7	
	goto	RC5_READ
; test for NEC
; is it >8ms (D8000, H1F40)
	movf	TMR1H,w			;
	sublw	H'1F'			 
	movwf	TEMP
	movf	TMR1L,w
	sublw	H'3F'
	btfss	STATUS,C
	decf	TEMP,f
	btfsc	TEMP,7
	goto	NEC_READ		; NEC code
; test for Sony
; is it <2.55ms (2550 or H'09F6)
	movf	TMR1H,w			;
	sublw	H'09'			
	movwf	TEMP
	movf	TMR1L,w
	sublw	H'F6'
	btfss	STATUS,C
	decf	TEMP,f
	btfss	TEMP,7	
	goto	SONY_READ
; test for RC6
; is it <2.8ms (2800 or H'0AF0')
	movf	TMR1H,w			;
	sublw	H'0A'			
	movwf	TEMP
	movf	TMR1L,w
	sublw	H'F0'
	btfss	STATUS,C
	decf	TEMP,f
	btfss	TEMP,7	
	goto	RC6_READ
	retlw	D'00'			; not recognised
NEC_READ

; read IR signal that's based on pulse distance protocol
; start train is a 38kHz burst at 9ms and 4.5ms of no burst
; data sent as an 8-bit address (LSB first) then a complementary version of the address or address extension
; further data sent as an 8-bit command (LSB first) then a complementary version of the command
; logic 1 is 560us 38kHz burst and 1690us of no burst
; logic 0 is a 560us 38kHz burst and 560us of no burst
; At the end of the 32bit data is a tail pulse comprising 560us of a 38kHz burst
; data is sent once
; a repeat indication (transmit button held on) is 9000us 38kHz burst followed by 2250us no burst and a 560us 38kHz burst
; this is repeated each 110ms
; Check for start train
; comprises a 9ms 38kHz burst, read as a low of 9ms on IR detector, then followed by a high of 4.5ms (no 38kHz signal)

;	bsf		INTCON,GIE		; allow interrupt
; is it <10ms (D10000, H2710)
	movf	TMR1H,w			; ms
	sublw	H'27'				
	movwf	TEMP
	movf	TMR1L,w
	sublw	H'10'
	btfss	STATUS,C
	decf	TEMP,f
	btfsc	TEMP,7		
	retlw	D'00'			; no valid IR code
; PORTA,0 low for ~9ms (8-10ms) continue with NEC IR code decoding

; PORTA,0 has stayed low and then gone high within the acceptable ~9ms low period (8-11ms window)
	goto	STANDARD_P	; standard protocol check for next signals

; check timing for repeat
; if NEC_X is not zero (so possibly awaiting a repeat code) check for a high 2.25ms (Between 2 and 2.5ms
; after testing if not a repeat, clear NEC_X repeat flags
NEC_RPTX

	movf	NEC_X,w
	btfsc	STATUS,Z		; if zero, then not standard protocol	
	retlw	H'FF'			; not repeat mode so PORTA,0 went low before required 3.5ms minimum, so return with not valid 
; PORTA,0 goes low before 3.5ms then possibly a repeat at ~2.25ms
; check if counter is between 40 and 50 (2 to 2.5ms)
; >50?
	movf	COUNTER,w
	sublw	D'60'
	btfss	STATUS,C
	retlw	H'FF'		; if >50 not a repeat signal
; <40?
	movlw	D'40'
	subwf	COUNTER,w
	btfsc	STATUS,C
	retlw	H'FF'		; <40 so not a repeat signal
; Check for a 560us high (between 10 and 12 for counter)
	clrf	COUNTER
CK_560
	btfsc	PORTA,0
	goto	WITHIN_560
	btfss	INT_FLG,0	; check for an interrupt at 50us rate
	goto	CK_560
	bcf		INT_FLG,0
	incf	COUNTER,f	; count interrupts
; if equal to 13, exit with FF
	movf	COUNTER,w
	xorlw	D'13'
	btfsc	STATUS,Z
	retlw	H'FF'		; not within range of 560us
	goto	CK_560
WITHIN_560
;check if = to 10,11 or 12
	movf	COUNTER,w
	xorlw	D'10'
	btfsc	STATUS,Z 	
	retlw	H'88'		; valid repeat 
	movf	COUNTER,w
	xorlw	D'11'
	btfsc	STATUS,Z 	
	retlw	H'88'		; valid repeat 
	movf	COUNTER,w
	xorlw	D'12'
	btfsc	STATUS,Z 	
	retlw	H'88'		; valid repeat 
	retlw	H'FF'

STANDARD_P
; Now check for 4.5ms high (3.5 to 5.5ms window)
	movlw	D'70'		; 3.5ms
	movwf	COUNTER
	bsf		INTCON,GIE	; allow interrupt
; check PORTA,0
CK_3_2
	btfss	PORTA,0
	goto	NEC_RPTX	; gone low before counter has reduced to 0 (<3.5ms)
	btfss	INT_FLG,0	; check for an interrupt at 50us rate
	goto	CK_3_2 
	bcf		INT_FLG,0
	decfsz	COUNTER,f	; count interrupts
	goto	CK_3_2

; PORTA,0 can now go low up to a period of 2ms
; wait for more interrupts
	movlw	D'40'		; 2ms
	movwf	COUNTER
; PORTA,0 can go low in this period
CK_3_3
	btfss	PORTA,0
	goto	FOUR_POINT_FIVE_ms	; PORTA,0 has gone low within the acceptable ~4.5ms high period (3.5-5.5ms window)
	btfss	INT_FLG,0	; check for an interrupt at 50us rate
	goto	CK_3_3
	bcf		INT_FLG,0
	decfsz	COUNTER,f	; count interrupts
	goto	CK_3_3
	retlw	H'00'		; PORTA,0 stays high

; end of start train check
FOUR_POINT_FIVE_ms
	movlw	D'32'		; set up 32bit counter
	movwf	BIT_COUNT

; START_DATA ; start of data 
; clear data
	clrf	REMOTE_A	; remote control Address byte
	clrf	REM_A_BAR	; complementary value of address or address extension
	clrf	REMOTE_C	; remote control Command byte
	clrf	REM_C_BAR	; complementary value of command
	clrf	REM_A_MS	; Sony 13bit address ms bits

; start reading data
READ_DATA_NEC
; a 560us low
	movlw	D'8'			; allow a 400us minimum 
	movwf	COUNTER
; check PORTA,0
CK_3_4
	btfsc	PORTA,0
	retlw 	H'00'		; if PORTA,0 goes high then not a continuous low
	btfss	INT_FLG,0	; check for an interrupt at 50us rate
	goto	CK_3_4 
	bcf		INT_FLG,0
	decfsz	COUNTER,f	; count interrupts
	goto	CK_3_4
; PORTA,0 can now go high up to a period of 400us for a 800us maximum
; wait for more interrupts
	movlw	D'8'			; 400us
	movwf	COUNTER
; PORTA,0 can go high in this period
CK_3_5
	btfsc	PORTA,0
	goto	ONE_ZERO	; PORTA,0 has gone high within the acceptable ~560us low period (400us-800us window)
	btfss	INT_FLG,0	; check for an interrupt at 50us rate
	goto	CK_3_5
	bcf		INT_FLG,0
	decfsz	COUNTER,f	; count interrupts
	goto	CK_3_5
	retlw 	H'FF' 		; PORTA,0 stays low  
; test for a zero (high for 560us) or a one (high for 1690us)
ONE_ZERO
; Check for 560us high
	movlw	D'8'			; allow a 400us minimum 
	movwf	COUNTER
; check PORTA,0

CK_3_6
	btfss	PORTA,0
	retlw	H'FF'		; if PORTA,0 goes low then not a continuous high
	btfss	INT_FLG,0	; check for an interrupt at 50us rate
	goto	CK_3_6 
	bcf		INT_FLG,0
	decfsz	COUNTER,f	; count interrupts
	goto	CK_3_6

; PORTA,0 can now go high up to a period of 400us for a 800us maximum
; wait for more interrupts
	movlw	D'8'			; 400us
	movwf	COUNTER

; PORTA,0 can go low in this period
CK_3_7
	btfss	PORTA,0
	goto	LOGIC_0		; PORTA,0 has gone low within the acceptable ~560us high period
	btfss	INT_FLG,0	; check for an interrupt at 50us rate
	goto	CK_3_7
	bcf		INT_FLG,0
	decfsz	COUNTER,f	; count interrupts
	goto	CK_3_7
	goto	CHECK_FOR_1

LOGIC_0	; logic zero detected
	bcf		STATUS,C	; clear carry
; shift detected data into storage
SHIFT_DATA_NEC	
	rrf		REM_C_BAR,f	; complementary value of command
	rrf		REMOTE_C,f	; remote control Command byte
	rrf		REM_A_BAR,f	; complementary value of address or address extension
	rrf		REMOTE_A,f	; remote control Address byte
	
	decfsz	BIT_COUNT,f		; shift data for 32 bits
	goto	READ_DATA_NEC	; contine reading data
	goto	TAIL_NEC_RD	 	; end of 32 bit data, check for the tail (560us of burst)
	
CHECK_FOR_1 ; check for a logic 1

; Check for 1690us high  (already 560us high) so check for 1130us
	movlw	D'10'		; 500us (1300us min)
	movwf	COUNTER
; check PORTA,0

CK_3_8
	btfss	PORTA,0
	retlw	H'FF'		; if PORTA,0 goes low then not a continuous high
	btfss	INT_FLG,0	; check for an interrupt at 50us rate
	goto	CK_3_8 
	bcf		INT_FLG,0
	decfsz	COUNTER,f	; count interrupts
	goto	CK_3_8

; PORTA,0 can now go high up to a period of 600us extra
; wait for more interrupts

	movlw	D'14'		; 700us (2000us max)
	movwf	COUNTER

; PORTA,0 can go low in this period
CK_3_9
	btfss	PORTA,0
	goto	LOGIC_1		; PORTA,0 has gone low within the acceptable ~1690us high period
	btfss	INT_FLG,0	; check for an interrupt at 50us rate
	goto	CK_3_9
	bcf		INT_FLG,0
	decfsz	COUNTER,f	; count interrupts
	goto	CK_3_9
	retlw	H'00'		; error	

LOGIC_1
	bsf		STATUS,C	; data is a 1
	goto	SHIFT_DATA_NEC

TAIL_NEC_RD ; end of data tail

; a 560us low
	movlw	D'8'			; allow a 400us minimum 
	movwf	COUNTER
; check PORTA,0
CK_3_10
	btfsc	PORTA,0
	retlw 	H'00'		; if PORTA,0 goes high then not a continuous low
	btfss	INT_FLG,0	; check for an interrupt at 50us rate
	goto	CK_3_10 
	bcf		INT_FLG,0
	decfsz	COUNTER,f	; count interrupts
	goto	CK_3_10
; PORTA,0 can now go high up to a period of 400us for a 800us maximum
; wait for more interrupts
	movlw	D'8'			; 400us
	movwf	COUNTER
; PORTA,0 can go high in this period
CK_3_11
	btfsc	PORTA,0
	goto	TAIL_DET	; PORTA,0 has gone high within the acceptable ~560us low period
	btfss	INT_FLG,0	; check for an interrupt at 50us rate
	goto	CK_3_11
	bcf		INT_FLG,0
	decfsz	COUNTER,f	; count interrupts
	goto	CK_3_11
	retlw 	H'FF' 		; error

TAIL_DET ; tail is detected

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
; check if Address and Address bar are complementary
; *****not included to allow REM_A_BAR to be an address exension rather than a complementary REMOTE_A
;	comf	REM_A_BAR,w	; complementary value of address
;	xorwf	REMOTE_A,w	; remote control Address byte
;	btfss	STATUS,Z
;	retlw	H'00'			; error
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

; check if Command and Command bar are complementary

	comf	REM_C_BAR,w	; complementary value of command
	xorwf	REMOTE_C,w	; remote control Command byte
	btfss	STATUS,Z
	retlw	H'FF'		; error
NECS
	clrf	PROTOCOL	; set for NEC protocol
	retlw	H'A0'		; if data is decoded correctly send an 'AO'k return message

;.........................................................................................................................................................................................

SONY_READ
; There are 12 bit, 15 and 20 bits versions. The data consists of 7 command bits sent first and remaining bits are address. so 5, 8 or 13 bit address
; The data is started with a 2.4 ms mark, and a 0.6 ms space 
; 1 is  a 1200 s mark period followed by a 600 s space period
; 0 is  a 600 s mark period followed by a 600 s space period
; Carrier frequency is 40 kHz.
; repeat is by sending the data again including the 2.4ms mark and 0.6ms space. Repeated every 45 ms
; when reading, count the address bits used

; is it <2.7ms (D2700, H)
	bcf		T1CON,0		; stop timer and read
	movf	TMR1H,w		; ms
	sublw	H'A'				
	movwf	TEMP
	movf	TMR1L,w
	sublw	H'8C'
	btfss	STATUS,C
	decf	TEMP,f
	btfsc	TEMP,7		
	retlw	D'00'		; no valid IR code

; PORTA,0 low for ~2.4ms continue with Sony IR code decoding
	bsf		INTCON,GIE	; allow interrupt

; Now check for 0.6ms high (500us to 700us window)
	movlw	D'10'		; 500us
	movwf	COUNTER
; check PORTA,0

SYCK_3_2
	btfss	PORTA,0
	retlw	H'FF'		; if PORTA,0 goes low then not a continuous high
	btfss	INT_FLG,0	; check for an interrupt at 50us rate
	goto	SYCK_3_2 
	bcf		INT_FLG,0
	decfsz	COUNTER,f	; count interrupts
	goto	SYCK_3_2

; PORTA,0 can now go low up to a period of 200us to add up to 700us
; wait for more interrupts
	movlw	D'4'			; 200us
	movwf	COUNTER
; PORTA,0 can go low in this period
SYCK_3_3
	btfss	PORTA,0
	goto	EOS_SONY		; PORTA,0 has gone low within the acceptable ~600 high period (500us to 700us window)
	btfss	INT_FLG,0		; check for an interrupt at 50us rate
	goto	SYCK_3_3
	bcf		INT_FLG,0
	decfsz	COUNTER,f		; count interrupts
	goto	SYCK_3_3
	retlw	H'00'			; error return

; end of start train check
EOS_SONY ; end of start train for Sony code
	movlw	D'22'			; set up 24 bit counter to cover the 7 bit command and 5, 8 or 13bit address total length of 20maximum address and command  
	movwf	BIT_COUNT

; START_DATA ; start of data 
; clear data
	clrf	REMOTE_A		; remote control Address byte
	clrf	REM_A_MS		; address ms byte
	clrf	REMOTE_C		; remote control Command byte
	clrf	SONY_ADD_L		; address counter 12, 15 or 20 bit data (5, 8 or 13 bit address)
	clrf	REM_A_BAR		; NEC inverted address
; start reading data
READ_DATA_SONY
; a 600us low is a '0, a 1200us low is a '1'
	clrf	COUNTER			; start at zero and count up
; check PORTA,0
; check when PORTA,0 goes high
SYCK_3_4
	btfsc	PORTA,0
	goto	SY_3
	btfss	INT_FLG,0		; check for an interrupt at 50us rate
	goto  	SYCK_3_4 
	bcf		INT_FLG,0
	incfsz	COUNTER,f		; count interrupts
	goto	CK_CNTR_SONY
	retlw	H'FF'			; data error as over in length. (unlikely to be low that long) see bit 5 check that detects over in length
; check counter for > 32 if bit 5 is set. That's a low of 1600us  

CK_CNTR_SONY
	btfss	COUNTER,5		; bit 5 check for over a count of 32
	goto	SYCK_3_4
	retlw	H'FF'			; data read error	
SY_3
	
; check how long PORTA,0 was low
; COUNTER should be between 50us x 10 to 14 for a '0' (~600us)
; > a 10
	movf	COUNTER,w
	sublw	D'9'			; if 10 or more check for less than 14
	btfsc	STATUS,C
	retlw	D'00'			; error return as <10
; < 14
	movf	COUNTER,w
	sublw	D'14'			; if 10 or more check for less than 14
	btfss	STATUS,C
	goto	SONY_1			; check for a '1'
; detected as a '0'
	bcf		STATUS,C		; clear carry for a '0'
	goto	SHIFT_DATA_SONY 

SONY_1 ; check for a '1'
; COUNTER should be 50us x 22 to 26 for a '1' (1200us)
; > a 22
	movf	COUNTER,w
	sublw	D'21'			; if 22 or more check for less than 26
	btfsc	STATUS,C
	retlw	D'00'			; error return as <10
; < 26
	movf	COUNTER,w
	sublw	D'26'			; if 22 or more check for less than 26
	btfss	STATUS,C
	retlw	D'00'			; error return
; detected as a '1'
	bsf		STATUS,C		; set carry for a '1'

; shift detected data into storage
SHIFT_DATA_SONY

	rrf		REM_A_MS,f		; ms remote address byte
	rrf		REMOTE_A,f		; remote control Address byte	
	rrf		REMOTE_C,f		; remote control Command byte	; (this ends up having bit 7 with address ls byte that is fixed later) 

; wait for the time PORTA,0 is high. If over 600us then stop increasing SONY_ADD_L (address length counter)
; shift data with zeroes until BIT_COUNT is zero 

	movlw	D'14'			; 700us
	movwf	COUNTER

; PORTA,0 can go low in this period
SYCK_3_6
	btfss	PORTA,0
	goto	SONY_6			; PORTA,0 has gone low within the acceptable ~600 high period (up to 700us)
	btfss	INT_FLG,0		; check for an interrupt at 50us rate
	goto	SYCK_3_6
	bcf		INT_FLG,0
	decfsz	COUNTER,f		; count interrupts
	goto	SYCK_3_6
	goto	END_DATA_SONY	; end of data as PORTA,0 remains high >700us

SONY_6	
	incf	SONY_ADD_L,f	; address counter 12, 15 or 20 bit data (for 5, 8 or 13 bit address)
	decfsz	BIT_COUNT,f		; shift data for 24 bits
	goto	READ_DATA_SONY	; contine reading data
	retlw	H'00'			; bit count at zero so error. Should have stopped at 20 maximum rather than 24
	
END_DATA_SONY
	
	bcf		STATUS,C
	rrf		REM_A_MS,f		; ms remote address byte
	rrf		REMOTE_A,f		; remote control Address byte	
	rrf		REMOTE_C,f		; remote control Command byte	; (this ends up having bit 7 with address ls byte that is fixed later) 
	decfsz	BIT_COUNT,f		; shift data for 24 bits
	goto	END_DATA_SONY	; continue to shift until bit count is zero
	

; fix command and address shifts, shift command (for 24bit shift)
; move command right as is 7-bits not 8
	bcf		STATUS,C
	rrf		REMOTE_C,f

; up to 6.6ms left before retransmission. Check that there is no extra data (which would be invalid)
	movlw	D'3'
	call	DELAY_SET		; 1.2ms delay before checking for no signal

; check if there is a 2.5ms pause in signal. 

; a 2.5ms high
	movlw	D'50'			; 2.5ms
	movwf	COUNTER
; check PORTA,0
SONY_END1
	btfss	PORTA,0
	retlw 	H'00'			; if PORTA,0 goes low then no pause exists and so the entire data set is invalid code
	btfss	INT_FLG,0		; check for an interrupt at 50us rate
	goto	SONY_END1 
	bcf		INT_FLG,0
	decfsz	COUNTER,f		; count interrupts
	goto	SONY_END1

; set protocol
	movlw	D'01'
	movwf	PROTOCOL
	retlw	H'A0'

;........................................................................................................................................................................................

RC5_READ		
; 
; start code of two 1s
; 1 toggle bit (changes each new send (unchanged during repeat))
; 5 address bits, ms bits first
; 6 command bits, ms bits first
; repeat at 114ms
; 1 is 889us off, 889us on
; 0 is 889us on 889us off 
; most significant bits sent/received first
  
; PORTA,0 high so wait for low and use TMR1H and TMR1L as data rate. TMR1 increments at a 1us rate

; PORTA,0 just gone high
; wait for a low again
RC5_L
	btfsc	PORTA,0
	goto	RC5_L

; timer for 889us + 444us
; timer is set for 65536-1333 
	clrf	TMR1L 			; Clear Low byte
	bcf		T1CON,TMR1ON	; timer off
	movlw	H'CF'			; plus 4 to compensate for code to load timer
	movwf	TMR1L			; timer 1 low byte
	movlw	H'FA'			; 
	movwf	TMR1H
	bcf		PIR1,TMR1IF		; timer 1 interrupt flag cleared
	bsf		T1CON,TMR1ON	; timer on
	bcf		PIR1,TMR1IF		; timer 1 interrupt flag cleared

WAIT_RC5_B	
	btfss	PIR1,TMR1IF		; timer 1 interrupt flag cleared
	goto	WAIT_RC5_B

; START_DATA ; start of data 
; clear data

	clrf	REMOTE_A		; remote control Address byte 5-bits
	clrf	REMOTE_C		; remote control Command byte 6 bits
	movlw	D'11'
	movwf	BIT_COUNT

; start reading data at 1.778ms intervals
READ_RC5

; revised timer for 1.778ms  = 1778 counts
; timer is 65536-1778
	clrf	TMR1L 			; Clear Low byte
	bcf		T1CON,TMR1ON	; timer off
	movlw	H'12'			; plus 4 compensated for timer loading value
	movwf	TMR1L			; timer 1 low byte
	movlw	H'F9'			; 
	movwf	TMR1H
	bcf		PIR1,TMR1IF		; timer 1 interrupt flag cleared
	bsf		T1CON,TMR1ON	; timer on
	bcf		PIR1,TMR1IF		; timer 1 interrupt flag cleared

; wait for overflow flag 
WAIT_RC5_1	
	btfss	PIR1,TMR1IF		; timer 1 interrupt flag cleared
	goto	WAIT_RC5_1

; read data
; set or clear carry and shift into command and address
	bcf		STATUS,C
	btfsc	PORTA,0
	bsf		STATUS,C

; Tracer **TEST
	bsf		PORTB,4			; see sample positioning
	nop
	bcf		PORTB,4
; end tracer

; shift detected data into storage
;11 shifts
SHIFT_DATA_RC5

	rlf		REMOTE_C,f		; remote control Command byte	; 
	rlf		REMOTE_A,f		; remote control Address byte	

	decfsz	BIT_COUNT,f		; shift data for 11 bits
	goto	READ_RC5
;(this ends up having address bits in command; so shift left twice more for address in correct location
; Then shift command right with a cleared carry.)
	bcf		STATUS,C
	rlf		REMOTE_C,f		; remote control Command byte	; 
	rlf		REMOTE_A,f		; remote control Address byte	
	bcf		STATUS,C
	rlf		REMOTE_C,f		; remote control Command byte	; 
	rlf		REMOTE_A,f		; remote control Address byte	
	bcf		STATUS,C
	rrf		REMOTE_C,f
	bcf		STATUS,C
	rrf		REMOTE_C,f	

	movlw	D'5'
	call	DELAY_SET		; 2ms delay for trailing signal after sample

; check if there is a 25ms pause in signal. Done in two steps of 12.5ms

; a 12.5ms high
	movlw	D'250'			; 12.5ms
	movwf	COUNTER
; check PORTA,0
CK_PH_RC5
	btfss	PORTA,0
	retlw 	H'00'			; if PORTA,0 goes low then no pause
	btfss	INT_FLG,0		; check for an interrupt at 50us rate
	goto	CK_PH_RC5 
	bcf		INT_FLG,0
	decfsz	COUNTER,f		; count interrupts
	goto	CK_PH_RC5

; a 12.5ms high
	movlw	D'250'			; 12.5ms
	movwf	COUNTER
; check PORTA,0
CK_PH_RC5_1
	btfss	PORTA,0
	retlw 	H'00'			; if PORTA,0 goes low then no pause
	btfss	INT_FLG,0		; check for an interrupt at 50us rate
	goto	CK_PH_RC5_1 
	bcf		INT_FLG,0
	decfsz	COUNTER,f		; count interrupts
	goto	CK_PH_RC5_1

PHLPS
	movlw	D'02'			; set protocol for RC5
	movwf	PROTOCOL
	retlw	H'A0'			; return with an A0 for 'A0k' message, code read successfully

;......................................................................

RC6_READ		
; 
; start burst of 2.66ms then an 889us low, a 1 and three 0's then
; 1 toggle bit using 889us low/hi and 889 hi/low (changes each new send (unchanged during repeat))
; 8 address bits, ms bits first
; 8 command bits, ms bits first
; repeat at 106ms
; 1 is 444us on, 444us off (except toggle bit that's 889us, 2x)
; 0 is 444us off 444us on (except toggle bit that's 2x at 889us)
; most significant bits of address and command are sent/received first
  
; PORTA,0 high so wait for low and use TMR1H and TMR1L as data rate. TMR1 increments at a 1us rate

; PORTA,0 just gone high
; wait for a low again
RC6_L
	btfsc	PORTA,0
	goto	RC6_L

; timer for 889us x 5 +444us + 444us/2)
; timer is set for 65536-5111 = 60425
	clrf	TMR1L 			; Clear Low byte
	bcf		T1CON,TMR1ON	; timer off
	movlw	H'5D'			; plus compensate for code to load timer
	movwf	TMR1L			; timer 1 low byte
	movlw	H'EC'			; 
	movwf	TMR1H
	bcf		PIR1,TMR1IF		; timer 1 interrupt flag cleared
	bsf		T1CON,TMR1ON	; timer on
;	bcf		PIR1,TMR1IF		; timer 1 interrupt flag cleared

WAIT_RC6_B	
	btfss	PIR1,TMR1IF		; timer 1 interrupt flag cleared
	goto	WAIT_RC6_B

; START_DATA ; start of data 
; clear data

	clrf	REMOTE_A		; remote control Address byte 8-bits
	clrf	REMOTE_C		; remote control Command byte 8 bits
	movlw	D'16'
	movwf	BIT_COUNT

; start reading data at 889us intervals
READ_RC6

; load timer for 889us  = 889 counts
; timer is 65536-889 = 64647
	clrf	TMR1L 			; Clear Low byte
	bcf		PIR1,TMR1IF		; timer 1 interrupt flag cleared

	bcf		T1CON,TMR1ON	; timer off
	movlw	H'A0'			; plus compensating for code between loading timer each time
	movwf	TMR1L			; timer 1 low byte
	movlw	H'FC'			; 
	movwf	TMR1H
	bcf		PIR1,TMR1IF		; timer 1 interrupt flag cleared
	bsf		T1CON,TMR1ON	; timer on

; wait for overflow flag 
WAIT_RC6_1	
	btfss	PIR1,TMR1IF		; timer 1 interrupt flag cleared
	goto	WAIT_RC6_1

; read data
; set or clear carry and shift into command and address
	bcf		STATUS,C
	btfsc	PORTA,0
	bsf		STATUS,C

; Tracer **TEST
	bsf		PORTB,4			; see positioning of sampling 
	nop
	bcf		PORTB,4
; end tracer

; shift detected data into storage
;16 shifts
SHIFT_DATA_RC6

	rlf		REMOTE_C,f		; remote control Command byte	; 
	rlf		REMOTE_A,f		; remote control Address byte	

	decfsz	BIT_COUNT,f		; shift data for 11 bits
	goto	READ_RC6

	movlw	D'3'
	call	DELAY_SET		; 1.18ms delay to wait for trailing bit after sampling


; check if there is a 25ms pause in signal. Done in two steps of 12.5ms

; a 12.5ms high
	movlw	D'250'			; 12.5ms
	movwf	COUNTER
; check PORTA,0
CK_PH_RC6
	btfss	PORTA,0
	retlw 	H'00'			; if PORTA,0 goes low then no pause
	btfss	INT_FLG,0		; check for an interrupt at 50us rate
	goto	CK_PH_RC6 
	bcf		INT_FLG,0
	decfsz	COUNTER,f		; count interrupts
	goto	CK_PH_RC6

; a 12.5ms high
	movlw	D'250'			; 12.5ms
	movwf	COUNTER
; check PORTA,0
CK_PH_RC6_1
	btfss	PORTA,0
	retlw 	H'00'			; if PORTA,0 goes low then no pause
	btfss	INT_FLG,0		; check for an interrupt at 50us rate
	goto	CK_PH_RC6_1 
	bcf		INT_FLG,0
	decfsz	COUNTER,f		; count interrupts
	goto	CK_PH_RC6_1

PHLPS6
	movlw	D'03'			; set protocol for RC6
	movwf	PROTOCOL
	retlw	H'A0'			; return with an A0 for 'A0k' message, code read successfully

	end